package httpjsonlogger

import (
	"encoding/json"
	"net/http"
	"net/url"
	"testing"
	"time"
)

func TestLogFormatter(t *testing.T) {
	testurl, _ := url.ParseRequestURI("/test")
	req := &http.Request{Method: "GET", URL: testurl, Proto: "HTTP/1.0", RemoteAddr: "127.0.0.1:8080", Header: make(http.Header)}
	req.Header.Add("User-Agent", "myClient")
	req.Header.Add("Referer", "http://127.0.0.1/")
	ts := time.Now()
	buf := buildCommonLogLine(req, *testurl, ts, 200, 2048)
	//t.Fatalf(string(buf[:]))
	var d map[string]string
	json.Unmarshal(buf, &d)
	//fmt.Println("%v", d)
	if d["method"] != "GET" {
		t.Fatalf("Test log formatting method should be GET: ", d["method"])
	}
}
