# Using FPM and Jenkins to easiliy build OS packages

## Overview

[FPM][FPM] is a popular tool used to make the process of creating OS packages easier. This is especially true when you want to build packages for multiple operating systems.  FPM is installed on the Jenkins cluster and there is a Jenkins template method to help make the process as simple as possible if you follow a standard pattern.

FPM can create an OS package many different ways; however, this document focuses on creating a package from files within [a specified directory][FPM from dir].  FPM will create a package that lays down files in the same directory structure as found in the specifed directory.

## Usage

At the time of this writing, there is a single method (fpmPackageFromDir) for creating a package based on a directory source.  Parameters combined with the contents of special files within the source directory determine the type of package create as well as other aspects of the package.

fpmPackageFromDir accepts the following arguments:

```groovy
String package_type = "deb", String source = "fpm_source",  String fpm_scripts = "fpm_scripts", String version = "1.0.0", String iteration = "", String arch = "all", String extra_args = ""
```

At a minimum, you simply need to call the method in your jenkins.groovy in the steps section and it will attempt to create a package based on the contents of the package source directory.  By default, the directory within your repository that contains the package source is called `fpm_source`.

### Special files (`fpm_scripts`)

FPM supports many options for customizing the package being created. The most common options can be specified directory as arguments to the method as well as via special files in the package source.  If a `./fpm_scripts` directory is found at the root of the repository, it will look for specially named files to be used as parameters to FPM.

The following special files can be used in the fpm_scripts directory:

|File Name|Description|
|---------|--------------|
|NAME|Name of the package|
|VERSION|Version of the pacakge|
|ITERATION|The package iteration|
|ARCH|Arch type of the package|
|RPM_PARAMS|string of extra FPM parameters to be passed when creating an RPM package|
|DEB_PARAMS|string of extra FPM parameters to be passed when creating a DEB package|
|COMMON_PARAMS|string of extra FPM parameters to be passed at all times|
|DEB_DEPENDENCIES|A list of deb package dependencies. One package per line|
|DEB_PRE_DEPENDS|A list of deb package dependencies used for Pre-Depends|
|DEB_BUILD_DEPENDS|A list of deb package dependencies used for Build-Depends|
|RPM_DEPENDENCIES|A list of rpm package dependencies. One package per line|
|RPM_SUMMARY|A one line summary of your package. Only used for rpm packages|
|LICENSE|A one line describing the license type. ie. GPLv3|
|DESCRIPTION|A description of your package. Can contain multiple lines|
|{deb,rpm}/before-install|script to run before pacakge installation|
|{deb,rpm}/before-remove|script to run before package removal|
|{deb,rpm}/before-upgrade|script to run before package upgrade|
|{deb,rpm}/after-install|script to run after pacakge installation|
|{deb,rpm}/after-remove|script to run after pacakge removal|
|{deb,rpm}/after-upgrade|script to run after pacakge upgrade|

**NOTE:** The before and after install, remove, and upgrade scripts support package type specific directories (deb || rpm) and these script found in package type directories take precedence.  For example, a before-install script found at fpm_scripts/deb/before-install will take precedence over a before-install script located at fpm_scripts/before-install.

## Example

You can see an example of using fpmPackageFromDir in the [dta/fpm_tests][fpm_tests] repo.




[FPM]: https://github.com/jordansissel/fpm
[FPM from dir]: https://github.com/jordansissel/fpm/wiki/Source:-dir
[fpm_tests]: https://git.xarth.tv/dta/fpm_test
