package tv.twitch.jobs

import javaposse.jobdsl.dsl.DslScriptLoader
import javaposse.jobdsl.dsl.JobManagement
import javaposse.jobdsl.dsl.FileJobManagement
import javaposse.jobdsl.dsl.GeneratedItems
import javaposse.jobdsl.dsl.ScriptRequest

class Validator {

    static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println('Needs at least 1 argument')
            return
        }

        FileJobManagement jm = new FileJobManagement(new File('out'))
        jm.parameters.putAll(System.getenv())
        System.properties.each { def key, def value ->
            jm.parameters.put(key.toString(), value.toString())
        }

        String mode = args[0]
        if (mode != "test" && mode != "validate") {
            System.err.println("Invalid mode specified: ${mode}")
            return
        }
        args = args[1..args.size()-1]
        def badFiles = []
        args.each { String dirName ->
            File basePath= new File('.')
            URL urlBase = basePath.toURI().toURL()
            new File(dirName).traverse(
              type: groovy.io.FileType.FILES,
              nameFilter: ~/.*\.groovy/,
              sort: { a, b -> a.name <=> b.name },
            ) { file ->
                ScriptRequest request = new ScriptRequest(file.toString(), null, urlBase, false)
                if (mode == 'test') {
                    Validator.generateItems(request, jm)
                } else {
                    try {
                        Validator.generateItems(request, jm)
                    } catch (Exception e) {
                        badFiles << file.toString()
                        File newFile = new File("ignored/$file")
                        println("Moving $file to $newFile")
                        newFile.getParentFile().mkdirs()
                        file.renameTo(newFile)
                        println(e.toString());
                        println(e.getMessage());
                        println(e.getStackTrace());  
                    }
                }
            }
        }
        if (mode == 'validate' && badFiles.size() > 0) {
            System.err.println("WARNING: The following files failed validation: ${badFiles.join(', ')}")
        }
    }

    static void generateItems(ScriptRequest request, JobManagement jm) {
        GeneratedItems items = DslScriptLoader.runDslEngine(request, jm)
        items.jobs.each { job ->
            println "generated job ${job.jobName}"
        }
        items.views.each { view ->
            println "generated view ${view.name}"
        }
        items.configFiles.each { configFile ->
            println "generated config file ${configFile.name}"
        }
        items.userContents.each { userContent ->
            println "generated user content ${userContent.path}"
        }
    }
}
