job('TEMPLATE-autobuild') {
	concurrentBuild true
	triggers {
		githubPush()
		scm('')
	}
	configure { project ->
		project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
		project / publishers / 'org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter' {
			commitShaSource(class: "org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource")
			reposSource(class: "org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource")
			contextSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource")
			statusResultSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource")
		}
	}
	wrappers {
		sshAgent 'git-aws-read-key'
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			file('ARTI_CONFIG_FILE', 'dta_arti_creds')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}
