// If you are looking for the right template for a deployment using chasqui, you probably want TEMPLATE-deploy-aws-chasqui.
// This long list of templates is here to make our job of migration from courier to chasqui easier.


job('TEMPLATE-deploy-aws-chasqui') {
	quietPeriod 0
	concurrentBuild true
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}

job('TEMPLATE-deploy-chasqui') {
	quietPeriod 0
	concurrentBuild true
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		environmentVariables {
			envs([
				'HTTP_PROXY': 'http://proxy.internal.justin.tv:9797/',
				'HTTPS_PROXY': 'http://proxy.internal.justin.tv:9797/',
				'NO_PROXY': 'localhost,127.0.0.1,127.0.1.1,127.0.0.0/8,199.9.248.0/21,192.16.64.0/21,10.0.0.0/8,.xarth.tv,.twitch.a2z.com,.live-video.a2z.com,.internal.justin.tv,.internal.twitch.tv,.justin.tv,.twitch.tv,.jtvnw.net,169.254.169.254,52.223.192.0/18',
			])
		}
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}

job('TEMPLATE-minimal-skadi-deploy-chasqui') {
	quietPeriod 0
	concurrentBuild false
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}

job('TEMPLATE-skadi-deploy-chasqui') {
	quietPeriod 0
	concurrentBuild false
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
	configure { project ->
    project / buildWrappers << 'com.cloudbees.jenkins.plugins.sshagent.SSHAgentBuildWrapper' {
      credentialIds {
        string 'git-aws-read-key'
      }
    }
  }
}
