job('TEMPLATE-deploy') {
	quietPeriod 0
	concurrentBuild true
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
		stringParam 'HOSTS'
		stringParam('HOSTS2', '','Variable to hold additional hosts')
		stringParam('HOSTS3', '','Variable to hold additional hosts')
		stringParam('HOSTS4', '','Variable to hold additional hosts')
		stringParam('HOSTS5', '','Variable to hold additional hosts')
		stringParam('HOSTS6', '','Variable to hold additional hosts')
		stringParam('HOSTS7', '','Variable to hold additional hosts')
		stringParam('HOSTS8', '','Variable to hold additional hosts')
		stringParam('HOSTS9', '','Variable to hold additional hosts')
	}
	wrappers {
		sshAgent 'jtv-deploy-user'
		preBuildCleanup()
		timestamps()
		environmentVariables {
			envs([
				'HTTP_PROXY': 'http://proxy.internal.justin.tv:9797/',
				'HTTPS_PROXY': 'http://proxy.internal.justin.tv:9797/',
				'NO_PROXY': 'localhost,127.0.0.1,127.0.1.1,127.0.0.0/8,199.9.248.0/21,192.16.64.0/21,10.0.0.0/8,.xarth.tv,.twitch.a2z.com,.live-video.a2z.com,.internal.justin.tv,.internal.twitch.tv,.justin.tv,.twitch.tv,.jtvnw.net,169.254.169.254,52.223.192.0/18,internal.di.twitch.a2z.com',
			])
		}
		credentialsBinding {
			file('COURIER_CONFIG_FILE', 'courier.conf')
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}

job('TEMPLATE-deploy-aws') {
	quietPeriod 0
	concurrentBuild true
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
		stringParam 'HOSTS'
		stringParam('HOSTS2', '','Variable to hold additional hosts')
		stringParam('HOSTS3', '','Variable to hold additional hosts')
		stringParam('HOSTS4', '','Variable to hold additional hosts')
		stringParam('HOSTS5', '','Variable to hold additional hosts')
		stringParam('HOSTS6', '','Variable to hold additional hosts')
		stringParam('HOSTS7', '','Variable to hold additional hosts')
		stringParam('HOSTS8', '','Variable to hold additional hosts')
		stringParam('HOSTS9', '','Variable to hold additional hosts')
	}
	wrappers {
		sshAgent 'jtv-deploy-user'
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('COURIER_CONFIG_FILE', 'courier.conf')
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}

job('TEMPLATE-minimal-skadi-deploy') {
	quietPeriod 0
	concurrentBuild false
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
		stringParam 'HOSTS'
		stringParam('HOSTS2', '','Variable to hold additional hosts')
		stringParam('HOSTS3', '','Variable to hold additional hosts')
		stringParam('HOSTS4', '','Variable to hold additional hosts')
		stringParam('HOSTS5', '','Variable to hold additional hosts')
		stringParam('HOSTS6', '','Variable to hold additional hosts')
		stringParam('HOSTS7', '','Variable to hold additional hosts')
		stringParam('HOSTS8', '','Variable to hold additional hosts')
		stringParam('HOSTS9', '','Variable to hold additional hosts')
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('COURIER_CONFIG_FILE', 'courier.conf')
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
}

job('TEMPLATE-skadi-deploy') {
	quietPeriod 0
	concurrentBuild false
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'SKADI_ID'
		stringParam 'ENVIRONMENT'
		stringParam 'HOSTS'
		stringParam('HOSTS2', '','Variable to hold additional hosts')
		stringParam('HOSTS3', '','Variable to hold additional hosts')
		stringParam('HOSTS4', '','Variable to hold additional hosts')
		stringParam('HOSTS5', '','Variable to hold additional hosts')
		stringParam('HOSTS6', '','Variable to hold additional hosts')
		stringParam('HOSTS7', '','Variable to hold additional hosts')
		stringParam('HOSTS8', '','Variable to hold additional hosts')
		stringParam('HOSTS9', '','Variable to hold additional hosts')
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('COURIER_CONFIG_FILE', 'courier.conf')
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'dta_tools_deploy', 'dta_tools_deploy'
		}
	}
	configure { project ->
    project / buildWrappers << 'com.cloudbees.jenkins.plugins.sshagent.SSHAgentBuildWrapper' {
      credentialIds {
        string 'git-aws-read-key'
        string 'jtv-deploy-user'
      }
    }
  }
}
