job('TEMPLATE-packer') {
  using 'TEMPLATE-autobuild'
  parameters {
    stringParam 'PACKER_VERSION','0.12.3','Version of packer to build with.'
    stringParam 'PACKER_MD5','d11c7ff78f546abaced4fcc7828f59ba1346e88276326d234b7afed32c9578fe','MD5SUM that matches the packer deb package used.'
  }
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY_ID', 'jenkins-packer-core-services-aws-access-key'
      string 'AWS_SECRET_ACCESS_KEY', 'jenkins-packer-core-services-aws-secret-key'
    }
    colorizeOutput()
  }
  scm {
    git {
      remote {
        github 'dta/baseami-packer', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
     shell 'wget "https://releases.hashicorp.com/packer/\${PACKER_VERSION}/packer_\${PACKER_VERSION}_linux_amd64.zip"'
     shell 'echo "\${PACKER_MD5} packer_\${PACKER_VERSION}_linux_amd64.zip" | sha256sum --check'
     shell 'unzip "packer_\${PACKER_VERSION}_linux_amd64.zip"'
  }
}

job('TEMPLATE-packer-runner') {
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY_ID', 'jenkins-packer-core-services-aws-access-key'
      string 'AWS_SECRET_ACCESS_KEY', 'jenkins-packer-core-services-aws-secret-key'
    }
    colorizeOutput()
  }
  publishers {
    archiveArtifacts {
      pattern('output/*.json')
      allowEmpty(true)
      onlyIfSuccessful(true)
    }
  }
}
