import javaposse.jobdsl.dsl.helpers.step.*

/*
Temporary method for testing arti uploading
'releases' is empty so arti can handle that
*/
StepContext.metaClass.uploadDebV2 = { String debPath, releases = [], customRepo = "" ->
  if ( customRepo != '' ) {
    customRepoParameter = "-r ${customRepo}"
  } else {
    customRepoParameter = ""
  }
  if ( releases instanceof String ) {
    releases = [releases]
  }
  releases.each { rel ->
    shell """
      |if [ -z \$ARTI_CONFIG_FILE ]; then
      |  echo 'You must provide a path to credentials for arti to use via the ARTI_CONFIG_FILE environment variable.'
      |  echo 'See: https://wiki.twitch.com/display/DTA/Jenkins+User+Guide#JenkinsUserGuide-WhyisuploadDeb/uploadRPMfailinginmyJenkinsjob?'
      |  exit 1
      |fi
      |arti -c \$ARTI_CONFIG_FILE deb -o ${rel} ${customRepoParameter} ${debPath}
    """.stripMargin()
   }
   if ( releases == [] ) {
     shell """
      |if [ -z \$ARTI_CONFIG_FILE ]; then
      |  echo 'You must provide a path to credentials for arti to use via the ARTI_CONFIG_FILE environment variable.'
      |  echo 'See: https://wiki.twitch.com/display/DTA/Jenkins+User+Guide#JenkinsUserGuide-WhyisuploadDeb/uploadRPMfailinginmyJenkinsjob?'
      |  exit 1
      |fi
      |arti -c \$ARTI_CONFIG_FILE deb ${customRepoParameter} ${debPath}
     """.stripMargin()
   }
 }

/*
Temporary method for testing arti uploading
'releases' is used here instead of letting arti handle it because arti currently doesn't default to uploading to recent repos
*/
StepContext.metaClass.uploadRPMV2 = { String rpmPath, releases = ['centos7', '2016.09', '2017.03', '2017.09', '2018.03'], customRepo = "" ->
  if ( customRepo != '' ) {
    customRepoParameter = "-r ${customRepo}"
  } else {
    customRepoParameter = ""
  }
  if ( releases instanceof String ) {
    releases = [releases]
  }
  releases.each { rel ->
    repo = ''
    switch (rel) {
        case 'centos7':
            repo = 'ip-centos7'
            break
        case '2016.09':
            repo = 'ip-amzn-2016.09'
            break
        case '2017.03':
            repo = 'ip-amzn-2017.03'
            break
        case '2017.09':
            repo = 'ip-amzn-2017.09'
            break
        case '2018.03':
            repo = 'ip-amzn-2018.03'
            break
    }
    shell """
      |if [ -z \$ARTI_CONFIG_FILE ]; then
      |  echo 'You must provide a path to credentials for arti to use via the ARTI_CONFIG_FILE environment variable.'
      |  echo 'See: https://wiki.twitch.com/display/DTA/Jenkins+User+Guide#JenkinsUserGuide-WhyisuploadDeb/uploadRPMfailinginmyJenkinsjob?'
      |  exit 1
      |fi
      |arti -c \$ARTI_CONFIG_FILE rpm -o ${repo} ${customRepoParameter} ${rpmPath}
    """.stripMargin()
  }
  if ( releases == [] ) {
    shell """
      |if [ -z \$ARTI_CONFIG_FILE ]; then
      |  echo 'You must provide a path to credentials for arti to use via the ARTI_CONFIG_FILE environment variable.'
      |  echo 'See: https://wiki.twitch.com/display/DTA/Jenkins+User+Guide#JenkinsUserGuide-WhyisuploadDeb/uploadRPMfailinginmyJenkinsjob?'
      |  exit 1
      |fi
      |arti -c \$ARTI_CONFIG_FILE rpm ${customRepoParameter} ${rpmPath}
    """.stripMargin()
  }
}

/**
 * uploadDeb(path)
 * uploadDeb(path, version)
 * uploadDeb(path, [version1, version2])
 *
 * The first form uploads the deb to the default flavours of ubuntu
 * The second form permits you to specify a specific version of ubuntu
 * The third form permits you to specify multiple specific versions of ubuntu
 *
 * The default versions are: precise, lucid, trusty, and xenial
 */
StepContext.metaClass.uploadDeb = { String debPath, releases = ['trusty', 'xenial', 'bionic'], customRepo = "" ->
uploadDebV2(debPath, releases)
}

/** Artifactory
 * uploadNpm(path)
 * uploadNpm(repo, path)
 */

StepContext.metaClass.uploadNPM = { String path, repo = 'ip-npm' ->
  cmd = 'curl -udta_tools:$dta_tools_deploy https://npm.pkgs.xarth.tv/artifactory/api/npm/auth > ~/.npmrc ; cd ' + path +  '; echo "email = dta@justin.tv" >> ~/.npmrc ; cd package ; npm publish --registry "https://npm.pkgs.xarth.tv/artifactory/api/npm/"' + repo

  shell cmd
}
/** Artifactory
 * uploadPyPi(path)
 */

StepContext.metaClass.uploadPyPi = { String pyPath ->
shell """#!/bin/bash
set -euo pipefail
APIKEY=\$(curl -s --fail -udta_tools:\$dta_tools_deploy -XGET https://gen.pkgs.xarth.tv/artifactory/api/security/apiKey | jq -r ".apiKey")
set +x
cat <<- EOF > ~/.pypirc
[distutils]
index-servers = local
[local]
repository: https://pypi.pkgs.xarth.tv
username: dta_tools
password: \$APIKEY
EOF
set -x
cd ${pyPath} && python setup.py sdist upload -r local
"""
}

/** Artifactory
 * uploadGem(path)
 * uploadGem(path, version)
 * uploadGem(repo, path, [version1, version2])
 */

StepContext.metaClass.uploadGem = { String gemPath, repo = 'v-rubygems' ->
  cmd = 'curl -udta_tools:$dta_tools_deploy https://gem.pkgs.xarth.tv/artifactory/api/gems/' + repo + '/api/v1/api_key.yaml > ~/.gem/credentials ; chmod 600 ~/.gem/credentials ; gem push ' + gemPath + ' --host https://gem.pkgs.xarth.tv/artifactory/api/gems/' + repo
  shell cmd
}

/** Artifactory
 * uploadRPM(path)
 * uploadRPM(path, version)
 * uploadRPM(path, [version1, version2], repo)
 *
 * The first form uploads the deb to the default flavours of ubuntu
 * The second form permits you to specify a specific version of ubuntu
 * The third form permits you to specify multiple specific versions of ubuntu
 *
 * The default versions are: precise, lucid, trusty, and xenial
 */

StepContext.metaClass.uploadRPM = { String rpmPath, releases = ['centos7', '2016.09', '2017.03', '2017.09', '2018.03'] ->
uploadRPMV2(rpmPath, releases)
}

StepContext.metaClass.uploadWin = { String winPath, String versionPath, repo = 'ip-windows', arch = 'x64' ->
    def winNameStub = ''
    def extension = winPath.split(/\./)[1]
    switch (extension) {
      case 'msi':
      winNameStub = winPath.split("/").last().replaceFirst(".msi", "")
      break

      case 'exe':
      winNameStub = winPath.split("/").last().replaceFirst(".exe", "")
      break
    }
    first_letter = winNameStub.take(1)
    cmd = 'VERSION=$(cat ' + versionPath + ' || exit "Version not specified or does not exist"); curl --fail -udta_tools:$dta_tools_deploy -XPUT "https://gen.pkgs.xarth.tv/artifactory/' + repo + '/' + arch + '/' + first_letter + '/' + winNameStub + '_$VERSION.' + extension + '" -T ' + winPath
    shell cmd
}

/**
 * uploadDirtyDeb(path)
 * uploadDirtyDeb(path, version)
 * uploadDirtyDeb(path, [version1, version2])
 *
 * The first form uploads the deb to the default flavours of ubuntu
 * The second form permits you to specify a specific version of ubuntu
 * The third form permits you to specify multiple specific versions of ubuntu
 *
 * The default versions are: precise, lucid
 */
StepContext.metaClass.uploadDirtyDeb = { String debPath, releases = ['precise', 'lucid'] ->
	shell 'echo "uploadDirtyDeb is deprecated. Remove it from your jenkins.groovy"'
}
