import javaposse.jobdsl.dsl.helpers.step.*

StepContext.metaClass.saveChasquiArtifact = { String name, String directory, String bucket, String account_id, String type = "server", String taskdef_arn = "" ->
  shell """#!/bin/bash
TMP_DIR="\$(mktemp -d --suff=chasqui)"
CHASQUI_AWS_CONFIG="\${TMP_DIR}/chasqui_aws_config"
cp -a ${directory}/. \${TMP_DIR}
cd \${TMP_DIR}
cp -a \${WORKSPACE}/{codedeploy,chasqui.yml,appspec.yml} .
zip -r /tmp/\$BUILD_TAG-\$GIT_COMMIT.zip .
echo "[default]
region = us-west-2
role_arn = arn:aws:iam::${account_id}:role/chasqui-${name}-artifacts
credential_source=Ec2InstanceMetadata
duration_seconds=900
s3 =
  multipart_threshold=50GB
" > \${CHASQUI_AWS_CONFIG}
AWS_CONFIG_FILE=\${CHASQUI_AWS_CONFIG} AWS_STS_REGIONAL_ENDPOINTS=regional aws s3 cp /tmp/\$BUILD_TAG-\$GIT_COMMIT.zip s3://${bucket}/${name}/${name}-\$GIT_COMMIT.zip
if [[ "${type}" == "ecs" || "${type}" == "ECS" ]]; then
  TMP_APPSPEC_FILE="\$(mktemp --suff=appspec)"
  sed -e 's/\${taskdef_arn}/${taskdef_arn}/g' appspec.yml > \${TMP_APPSPEC_FILE}
  AWS_CONFIG_FILE=\${CHASQUI_AWS_CONFIG} AWS_STS_REGIONAL_ENDPOINTS=regional aws s3 cp \${TMP_APPSPEC_FILE} s3://${bucket}/${name}/${name}-\$GIT_COMMIT-appspec.yaml
  rm -f \${TMP_APPSPEC_FILE}
fi
rm -f \${CHASQUI_AWS_CONFIG}
artifact_size=\$(wc -c < /tmp/\$BUILD_TAG-\$GIT_COMMIT.zip)
echo -n "jenkins.job.\$JOB_NAME:\$artifact_size|g" | nc -u -w 1 statsd.central.twitch.a2z.com 8125 || true
cd \${WORKSPACE}
rm -rf \${TMP_DIR} /tmp/\$BUILD_TAG-\$GIT_COMMIT.zip
  """
}

StepContext.metaClass.deployChasquiArtifact = { String name, String stage, String bucket ->
  shell """
TMP_DIR="\$(mktemp -d --suff=chasqui)"
CHASQUI_AWS_CONFIG="\${TMP_DIR}/chasqui_aws_config"
MAXLOOP=360; WAIT=10; RESULT_OUT="\${TMP_DIR}/chasquicli.out"
echo "[default]
region = us-west-2
role_arn = arn:aws:iam::533587911173:role/ChasquiLambda-LambdaRole-OGINSR38JNKH
credential_source=Ec2InstanceMetadata
duration_seconds=3600
" > \${CHASQUI_AWS_CONFIG}
AWS_CONFIG_FILE=\${CHASQUI_AWS_CONFIG} AWS_STS_REGIONAL_ENDPOINTS=regional chasquicli deploy -f \$RESULT_OUT -s ${name} -v \$GIT_COMMIT -g ${stage} -b ${bucket} -d \$GIT_COMMIT
if [ \$? != 0 ]; then
  rm -rf \$TMP_DIR \${CHASQUI_AWS_CONFIG}
  exit 1
fi
set +x
for i in `seq 1 \$MAXLOOP`; do
  echo "Checking deployment status..."
  OUT=`AWS_CONFIG_FILE=\${CHASQUI_AWS_CONFIG} AWS_STS_REGIONAL_ENDPOINTS=regional chasquicli status -w \$WAIT -f \$RESULT_OUT`
  if [ \$? != 0 ]; then
    echo "\$OUT"
    break
  fi
  echo "\$OUT"
  STATUS=`echo "\$OUT" | head -1 | awk -F':' '{ print \$1 }'`
  if [ "\$STATUS" = "INPROGRESS" ]; then
    continue
  elif [ "\$STATUS" = "SUCCEEDED" ]; then
    break
  else
    rm -rf \$TMP_DIR \${CHASQUI_AWS_CONFIG}
    exit 1
  fi
done
rm -rf \$TMP_DIR \${CHASQUI_AWS_CONFIG}
  """
}
