import javaposse.jobdsl.dsl.helpers.step.*

/* Deploy via Courier
 * runCourier(repo, dir)
 * runCourier(repo, dir, additional_args)
 *
 * Run courier against the hosts list provided to us by skadi
 * We wrap this in order to handle larger list of hosts broken up for us by skadi
 * into HOSTS, HOSTS2, HOSTS3, etc..
 */
StepContext.metaClass.runCourier = { String repo, String dir, String additional_args = "" ->
        shell """
get_host_list () {
  eval echo \\\$HOSTS\$1
}
i=0
while true ; do
  i=`expr \$i + 1`
  HOSTLIST=\$HOSTS
  if [ "\$i" != "1" ] ; then
    HOSTLIST=`get_host_list \$i`
  fi
  if [ "\$HOSTLIST" = "" ] ; then
    break
  fi
  courier deploy --repo ${repo} --dir ${dir} --hosts \$HOSTLIST --config-path \$COURIER_CONFIG_FILE
done
"""
}

StepContext.metaClass.saveDeployArtifact = { String repo, String directory ->
  shell """#!/bin/bash
    |unset AWS_CONFIG_FILE AWS_ACCESS_KEY_ID AWS_SECRET_ACCESS_KEY
    |courierTmpDir="\$(mktemp -d /tmp/courier.XXXXXX)"
    |cp -a ${directory}/. \${courierTmpDir}
    |cd \${courierTmpDir}
    |tar -czf /tmp/\$BUILD_TAG-\$GIT_COMMIT.tgz .
    |aws s3 cp /tmp/\$BUILD_TAG-\$GIT_COMMIT.tgz s3://devtools-deploy-artifacts/${repo}/\$GIT_COMMIT.tgz
    |aws s3 cp /tmp/\$BUILD_TAG-\$GIT_COMMIT.tgz s3://core-devtools-deploy-artifact/${repo}/\$GIT_COMMIT.tgz
    |artifact_size=\$(wc -c < /tmp/\$BUILD_TAG-\$GIT_COMMIT.tgz)
    |echo -n "jenkins.job.\$JOB_NAME:\$artifact_size|g" | nc -u -w 1 statsd.central.twitch.a2z.com 8125 || true
    |cd -
    |rm -rf \${courierTmpDir}
    |rm /tmp/\$BUILD_TAG-\$GIT_COMMIT.tgz
  """.stripMargin()
}

StepContext.metaClass.saveDirtyDeployArtifact = { String repo, String directory ->
  shell 'echo "saveDirtyDeployArtifact is deprecated. Remove it from your jenkins.groovy"'
}

StepContext.metaClass.downloadDeployArtifact = { String repo, String extract_dir = '', Boolean ignore_error = false ->
  shell """
    |if [ "$ignore_error" = "true" ]; then
    |  set +e
    |fi
    |unset AWS_CONFIG_FILE AWS_ACCESS_KEY_ID AWS_SECRET_ACCESS_KEY
    |
    |[ -n "${extract_dir}" ] && cd "${extract_dir}"
    |aws s3 cp s3://core-devtools-deploy-artifact/${repo}/\$GIT_COMMIT.tgz \$GIT_COMMIT.tgz &&
    |tar -xzf \$GIT_COMMIT.tgz &&
    |rm \$GIT_COMMIT.tgz
    |true # If we got this far, we must have ignore_error = true
  """.stripMargin()
}
