import javaposse.jobdsl.dsl.helpers.publisher.PublisherContext

/**
 * Updates commit status in GitHub.
 *
 * @param commitSha commit ID to update, may contain token macros.
 * @param repositoryUrl git URL (see {@link java.com.cloudbees.jenkins.GitHubRepositoryName} for supported formats)
 * @param context name of the context to update, may contain token macros.
 * @param backrefUrl URL the status context will point back to, may contain token macros.
 */
PublisherContext.metaClass.githubCommitNotifier { String commitSha = "", String repositoryUrl = "", String context = "", String backrefUrl = "" ->
  publisherNodes << new NodeBuilder().'org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter' {
    if (commitSha == "") {
      commitShaSource(class: "org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource")
    } else {
      commitShaSource(class: "org.jenkinsci.plugins.github.status.sources.ManuallyEnteredShaSource") / sha(commitSha)
    }

    if (repositoryUrl == "") {
      reposSource(class: "org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource")
    } else {
      reposSource(class: "org.jenkinsci.plugins.github.status.sources.ManuallyEnteredRepositorySource") / url(repositoryUrl)
    }

    if (context == "") {
      contextSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource")
    } else {
      contextSource(class: "org.jenkinsci.plugins.github.status.sources.ManuallyEnteredCommitContextSource") / 'context'(context)
    }

    statusResultSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource")

    if (backrefUrl == "") {
      statusBackrefSource(class: "org.jenkinsci.plugins.github.status.sources.BuildRefBackrefSource")
    } else {
      statusBackrefSource(class: "org.jenkinsci.plugins.github.status.sources.ManuallyEnteredBackrefSource") / backref(backrefUrl)
    }
  }
}
