import javaposse.jobdsl.dsl.helpers.step.*

// Save the lambda function code to S3, and mark it as the latest
// repo => owner/reponame
// dir => directory we want to push into the zip file
// s3_bucket => name of the s3_bucket to be used for artifact storage
// aws_profile_name => name of the aws profile used for s3 artifact storage
StepContext.metaClass.saveLambdaFunction = { String repo, String dir = ".", String s3_bucket = "core-devtools-deploy-artifact", String aws_profile_name = "core_deploy_artifact" ->
    // function name should maybe default to owner/service ??
    shell """
      cd ${dir} && zip -r --exclude="*.git*" /tmp/\$GIT_COMMIT.zip .
      aws s3 --profile ${aws_profile_name} cp /tmp/\$GIT_COMMIT.zip s3://${s3_bucket}/${repo}/\$GIT_COMMIT.zip
      rm /tmp/\$GIT_COMMIT.zip
    """
}

// Deploy updated lambda function to s3 as the named environment (assumes commit has already been saved)
// --TODO would be nice to cp directly but need CreateMultipartUpload on jenkins user + s3 bucket first
// repo => owner/reponame
// function_name => the name of the function on lambda (TODO: should maybe default to owner-service?)
// environment => "environment" for this function, copies zip package to that name in the bucket
// s3_bucket => name of the s3_bucket to be used for artifact storage
// aws_profile_name => name of the aws profile used for s3 artifact storage
StepContext.metaClass.deployLambdaFunction = { String repo, String function_name, String environment = "\$ENVIRONMENT", String s3_bucket = "core-devtools-deploy-artifact", String aws_profile_name = "core_deploy_artifact" ->
  shell """
    aws --profile ${aws_profile_name} s3 cp s3://${s3_bucket}/${repo}/\$GIT_COMMIT.zip /tmp/\$GIT_COMMIT.zip
    aws --profile ${aws_profile_name} s3 cp /tmp/\$GIT_COMMIT.zip s3://${s3_bucket}/${repo}/${environment}
    rm /tmp/\$GIT_COMMIT.zip
    AWS_CONFIG_FILE=\$AWS_UPLOADER_CONFIG_FILE aws --profile tw_lambda_uploader lambda update-function-code --function-name ${function_name} --publish --s3-bucket ${s3_bucket} --s3-key ${repo}/${environment}
  """
}

// Upload the lambda function code, and trigger the lambda function to use it directly
// -- Deprecated... may delete soon
// repo => owner/reponame
// function_name => the name of the function on lambda (TODO: should maybe default to owner-service?)
// s3_bucket => name of the s3_bucket to be used for artifact storage
// aws_profile_name => name of the aws profile used for s3 artifact storage
StepContext.metaClass.uploadLambdaFunction = { String repo, String function_name, String s3_bucket = "core-devtools-deploy-artifact", String aws_profile_name = "core_deploy_artifact" ->
  shell """
    aws --profile ${aws_profile_name} s3 cp s3://${s3_bucket}/${repo}/\$GIT_COMMIT.zip \$GIT_COMMIT.zip
    AWS_CONFIG_FILE=\$AWS_UPLOADER_CONFIG_FILE aws --profile tw_lambda_uploader lambda update-function-code --function-name ${function_name} --publish --zip-file fileb://\$GIT_COMMIT.zip
  """
}
