import javaposse.jobdsl.dsl.helpers.step.*

StepContext.metaClass.runPacker = { String dir = ".", String file = "packer.json", String options = "" ->
    shell """
      cd ${dir} && PATH=..:$PATH packer build ${options} ${file}
    """
}

////////////////////////////////////////////////////////////////////////////////////////
// Updated packer template functions that are more generic and provide more flexibility
////////////////////////////////////////////////////////////////////////////////////////

// Run the packer command we fetched earlier
// dir: the dir where your packer should run from
// file: the name of the packer.json file to use
// options: any additional packer build options to add to our cmd
StepContext.metaClass.packerRunCmd = { String dir = ".", String file = "packer.json", String options = "" ->
    shell """
      mkdir -p output
      cd ${dir} && PATH=.:..:$PATH packer build ${options} ${file}
    """
}

// Fetch the correct packer version for our run
StepContext.metaClass.packerFetchBin = { String packer_version = "1.0.4", String packer_md5 = "646da085cbcb8c666474d500a44d933df533cf4f1ff286193d67b51372c3c59e" ->
  shell "wget -nv \"https://releases.hashicorp.com/packer/${packer_version}/packer_${packer_version}_linux_amd64.zip\""
  shell "echo \"${packer_md5} packer_${packer_version}_linux_amd64.zip\" | sha256sum --check"
  shell "unzip \"packer_${packer_version}_linux_amd64.zip\""
}

// Update consul with the current ID for our baseAMI
// consul_kv: the name of the sub under consul baseami kv dir to drop manifest into
// description: a description of what this AMI is for
StepContext.metaClass.packerUpdateManifest = { String consul_kv = "unknown", String description = "-", String manifest_file = 'output/manifest.json', String target = 'baseami',String region = 'us-west-2' ->
  shell "jq --raw-output '.builds|.[]|select(.name==\"${target}\")|.artifact_id' ${manifest_file}  | tr , \"\\n\" | grep ${region} | tr : \"\\n\" | tail -n 1 > output/amiid.txt"
  shell "curl -v -X PUT -d @output/amiid.txt http://api.us-west-2.prod.consul.live-video.a2z.com/v1/kv/baseami/${region}/${consul_kv}/id"
  shell "curl -v -X PUT -d '${description}' http://api.us-west-2.prod.consul.live-video.a2z.com/v1/kv/baseami/${region}/${consul_kv}/description"
}

// Tool for doing testing of packer generated AMIs using serverspec
// specsDir: put serverspec test specs into test directory (http://serverspec.org/)
// varFile: create a json vars file to override anything in the packer.json file
StepContext.metaClass.packerRunTest = { String varFile = "", String specsDir = "test/specs" ->
  String packerCmd = "packer build -only=packer-testing"
  packerCmd = packerCmd + " -var 'specs_dir=${specsDir}'"
  if( varFile != "") {
    packerCmd = packerCmd + " -var-file=" + varFile
  }
  packerCmd = packerCmd + " ami-serverspec-testing-files/packer.json"
  shell """
aws s3 sync s3://dta-ami-serverspec-testing/files ami-serverspec-testing-files
rm -f output/success.txt
set +e
PATH=.:\$PATH $packerCmd
set -e
if [ -e output/success.txt ] ; then
  echo Success
  exit 0
fi
echo Fail
exit 1
  """
}
