import javaposse.jobdsl.dsl.helpers.step.*
import javaposse.jobdsl.dsl.helpers.publisher.*

PublisherContext.metaClass.reportQuality = { String repo, String directory, String file_pattern = '', String codecov_token = '', String options='', Boolean is_ghe = true, Boolean success_only = false ->
  flexiblePublish {
    conditionalAction {
      condition {
        status('SUCCESS', 'SUCCESS')
      }
      steps {
        reportCodeCoverage(repo, directory, file_pattern, codecov_token, options, is_ghe)
      }
    }
  }
  archiveJunit('test_report.xml') {
    allowEmptyResults()
  }
  archiveArtifacts {
      pattern('codecov_coverage.json')
      pattern('test_report.xml')
      onlyIfSuccessful(success_only)
      allowEmpty()
  }
}

/**
 * Takes (repo, directory) string arguments.  The contents of the directory will be recursively scanned
 * for code coverage reports and uploaded to our Codecov server for the given repo.
 *
 * In addition, a codecov_coverage.json will be generated with an aggregate summary of the code coverage.
 *
 * Note: This always exits with 0 so as to avoid failing builds.
 */
StepContext.metaClass.reportCodeCoverage = { String repo, String directory, String file_pattern = '', String codecov_token = '', String options='', Boolean is_ghe = true ->
  github_type = (is_ghe) ? 'ghe' : 'gh'
  if (codecov_token == '') {
    codecov_token = github_type
  }
  shell """
if [ -z "\$GIT_COMMIT" ]; then
  echo "Codecov can't get coverage, missing GIT_COMMIT environment variable"
  exit 0
fi
if [ ! -d ".git" ]; then
  if [ -z "\$GIT_BRANCH" ]; then
    echo "Codecov can't get coverage, missing GIT_BRANCH environment variable"
    exit 0
  fi
fi
if [ -z "${file_pattern}" ]; then
  curl -s https://codecov.xarth.tv/bash | bash -s - -t ${codecov_token} -r ${repo} -s ${directory} ${options}
else
  curl -s https://codecov.xarth.tv/bash | bash -s - -t ${codecov_token} -r ${repo} -s ${directory} -f "${file_pattern}" ${options}
fi
sleep 3
curl -s https://codecov.xarth.tv/api/${github_type}/${repo}/commit/\$GIT_COMMIT?access_token=9916c5c17be744039297352bbe6faa1e > codecov_coverage.json
exit 0
"""
}
