# libforerunner

### Update 2016-04-05: libforerunner is unsupported and barely used. Proceed at your own risk! ###

A go library for interacting with Forerunner

Forerunner and libforerunner together build a system where you can pass in
variables to an app via consul, env variables and command line flags.

In order to run forerunner you will need to set the following environment
variables.

* APP
* ENVIRONMENT

This allows forerunner to know the correct path in consul to lookup.

The consul path will be `settings/<app>/<enviornment>/<variable name>`.

## Variable Naming

Libforerunner will attempt to name variables conforming to standards for that
setup.

For example a go variable called `fooBar` will become:

* Command Line: `-foo-bar`
* ENV Var: `FOO_BAR`
* Consul-Key: `foo-bar`

Libforerunner will try and automatically detect word boundaries, but if it
fails you can manually set it via the struct tag "forerunner".

In addition there is an optional flag called "secret" that will cause
libforerunner to censor the struct field when printing. You can see an example
of both features below.

## Example

```go
type Config struct {
	Port       int `description:"The Port that example should bind to"`
	Host       string
	DBPassword string `forerunner:"db-password,secret"`
}

func main() {
	conf := &Config{Port: 8080}

	// Initalize Forerunner:
	// Values set in the DefaultConfig will be saved for setting in the
	// future.
	fr, err := libforerunner.Init(&libforerunner.Options{
		DefaultConfig: conf,
	})
	if err != nil {
		log.Fatal(err)
	}

	// Load conf with any settings from consul/env/flags:
	if err := fr.GetConfig(conf); err != nil {
		log.Fatal(err)
	}

	conf2 := &Config{}
	fr.GetConfig(conf2)
	if err != nil {
		log.Fatal(err)
	}

	// This will return 8080 if no flags or consul settings are set:
	fmt.Printf("Port: %d", conf2.Port)
}
```
