job {
	name 'release-lsconsul'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/lsconsul', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
  throttleConcurrentBuilds {
      maxPerNode 2
  }
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v'
		saveDeployArtifact 'release/lsconsul', '.manta'
	}
}

job {
	name 'release-lsconsul-aptly'
	using "TEMPLATE-deploy"
	steps {
		downloadDeployArtifact 'release/lsconsul'
		uploadDeb 'lsconsul.deb'
	}
}
