package main

import (
	"math/rand"
	"strings"

	"github.com/hashicorp/consul/api"
)

func parseFQDN(nodeinfo *api.AgentService) string {
	for _, tag := range nodeinfo.Tags {
		if strings.HasPrefix(tag, "fqdn=") {
			res := strings.SplitN(tag, "=", 2)
			return res[1]
		}
	}

	return ""
}

func shuffleServers(servers []string) []string {
	res := make([]string, 0, len(servers))

	for _, i := range rand.Perm(len(servers)) {
		res = append(res, servers[i])
	}

	return res
}
