// +build !go1.5

package pkgpath

import (
	"runtime"
	"strings"
)

func caller(skip int) (string, bool) {
	const sep = "."
	pc, _, _, ok := runtime.Caller(skip + 1)
	if !ok {
		return "", false
	}
	name := runtime.FuncForPC(pc).Name()
	if strings.Contains(name, sep) {
		name = name[:strings.LastIndex(name, sep)]
	}
	if name == strMain {
		name = mainPath
	}
	return name, (name != strMain)
}
