package messagequeue

import "time"

// BufferParameters is a set of parameters for the underlying buffer in a queue
// operator.
//
// Size is the limit of messages the operator will store before flushing.
// TTL is the number of seconds to wait to fill the buffer before flushing.
//
// Buffered operators will flush when the TTL timeout expires or the size is
// reached, whichever comes first.
type BufferParameters struct {
	Size int
	TTL  time.Duration
}

type bufferConfiguration struct {
	params   BufferParameters
	defaults BufferParameters
}

func (buf *bufferConfiguration) getParams() (size int, ttl time.Duration) {
	ttl = buf.params.TTL
	if ttl == 0 {
		ttl = buf.defaults.TTL
	}
	size = buf.params.Size
	if size == 0 {
		size = buf.defaults.Size
	}
	return
}

/*
type bufferedReceivingOperation struct {
	params      BufferParameters
	defaults    BufferParameters
	operationFn receivingOperation
	errChan     chan error
	messageChan chan *SQSMessage
}

func newBufferedReceivingOperation(fn messageOperation, params BufferParameters, defaults BufferParameters) *bufferedReceivingOperation {
	return &bufferedReceivingOperation{
		params,
		defaults,
		fn,
		make(chan Error),
		make(chan *SQSMessage),
	}
}

func (buf *bufferedReceivingOperation) processMessages() {
	var (
		ready, done bool
		timer       *time.Timer
		c           chan Time
	)
	size, ttl := buf.getParams()
	messages := make([]SQSMessage, 0, size)
	for {
		select {
		case message, ok := <-buf.messageChan:
			if !ok {
				done = true
				break
			}
			messages = append(messages, message)
			if len(messages) >= size {
				ready = true
				break
			}
			if timer == nil {
				timer = time.NewTimer(ttl * time.Second)
				c = timer.C
			}
		case <-c:
			ready = true
		}

		if ready || done {
			if timer != nil {
				timer.Stop()
			}
			ready = false
			timer = nil
			c = nil
			if len(buf) > 0 {
				err := buf.operationFn(messages)
				if err != nil {
					select { // non-blocking send err
					case buf.errChan <- err:
					}
				}
			}
			if done {
				buf.errChan <- nil
				close(buf.errChan)
				return
			}
			messages = messages[:0]
		}
	}
}
*/
