package messagequeue

import (
	"testing"
	"time"
)

type testBufferConfigurationGetParamsEntry struct {
	paramsSize   int
	paramsTTL    time.Duration
	defaultSize  int
	defaultTTL   time.Duration
	expectedSize int
	expectedTTL  time.Duration
}

func TestBufferConfigurationGetParams(t *testing.T) {
	var testInput = []testBufferConfigurationGetParamsEntry{
		{1, 2 * time.Second, 0, 0, 1, 2 * time.Second},
		{0, 3 * time.Second, 4, 0, 4, 3 * time.Second},
		{5, 0, 0, 6 * time.Second, 5, 6 * time.Second},
		{0, 0, 7, 8 * time.Second, 7, 8 * time.Second},
	}
	for _, e := range testInput {
		testBufferConfigurationGetParamsHelper(t, e)
	}
}

func testBufferConfigurationGetParamsHelper(t *testing.T, e testBufferConfigurationGetParamsEntry) {
	buf := &bufferConfiguration{BufferParameters{e.paramsSize, e.paramsTTL}, BufferParameters{e.defaultSize, e.defaultTTL}}
	size, ttl := buf.getParams()
	if size != e.expectedSize {
		t.Errorf("(%v) getParams() = %d, _, wanted %d", buf, size, e.expectedSize)
	}
	if ttl != e.expectedTTL {
		t.Errorf("(%v) getParams() = _, %d, wanted %d", buf, ttl, e.expectedTTL)
	}

}
