package messagequeue

import (
	"log"
	"time"

	"code.justin.tv/common/messagequeue"

	"github.com/aws/aws-sdk-go/aws"
)

func Example() error {
	q, err := messagequeue.NewSQSQueue(new(aws.Config), "example")
	if err != nil {
		return err
	}
	sender := q.Sender()
	err := sender.Send(q.Message([]byte("Hello!")))
	if err != nil {
		return err
	}
	receiver := q.Receiver(queue.BufferParamters{1, 10 * time.Second})
	messages, err := receiver.Receive()
	if err != nil {
		return err
	}
	for _, message := range messages {
		b, err := message.Bytes()
		if err != nil {
			return err
		}
		log.Println(b)
	}
}
