package messagequeue

import (
	"errors"

	"github.com/aws/aws-sdk-go/service/sqs"
)

// Message is the common interface for messages that all queue implementations
// support.
type Message interface {
	Bytes() ([]byte, error)
}

// SQSMessage is a message for an SQS queue.
type SQSMessage struct {
	*sqs.Message
}

// Bytes returns the []byte representation of the message body.
func (m *SQSMessage) Bytes() ([]byte, error) {
	if m.Message == nil {
		return nil, errors.New("SQSMessage is nil")
	}
	if m.Body == nil {
		return nil, errors.New("Body is nil")
	}
	return []byte(*m.Body), nil
}
