package config

import "testing"

type nameTestCase struct {
	in  string
	out string
}

func testNameTestCases(t *testing.T, funName string, fun func(string) string, cases []nameTestCase) {
	for _, c := range cases {
		if out := fun(c.in); out != c.out {
			t.Errorf("%s(%q) = %q; want %q", funName, c.in, out, c.out)
		}
	}
}

func TestConvertFlagToEnv(t *testing.T) {
	t.Parallel()
	testNameTestCases(t, "ConvertFlagToEnvName", ConvertFlagToEnvName,
		[]nameTestCase{
			{"twitch-env", "TWITCH_ENV"},
			{"github-oauth-token", "GITHUB_OAUTH_TOKEN"},
			{"foo", "FOO"},
			{"FOO", "FOO"},
		})
}

func TestConvertGoName(t *testing.T) {
	t.Parallel()
	testNameTestCases(t, "ConvertGoName", ConvertGoName,
		[]nameTestCase{
			{"", ""},
			{"FooBar", "foo-bar"},
			{"fooBar", "foo-bar"},
			{"fooBar", "foo-bar"},
			{"fooBAR", "foo-bar"},
			{"fooBarBAZ", "foo-bar-baz"},
		})
}
