// Code generated by protoc-gen-go.
// source: event.proto
// DO NOT EDIT!

/*
Package pbmsg is a generated protocol buffer package.

It is generated from these files:
	event.proto

It has these top-level messages:
	Event
	Extra
	ExtraHTTP
	UnusedExtra
	EventSet
*/
package pbmsg

import proto "github.com/golang/protobuf/proto"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

// Kind describes the type of event instrumented.
//
// When a request-response RPC takes place, there are several identifiable
// instants that can be observed by the client, and several that can be
// observed by the server.  Each of those is assigned a different Kind
// value.  An program may only be instrumented to measure a small subset
// of the possible events.  The goal of the Kind enumeration is to
// document all known events precisely, so that if two programs emit an
// event with a particular Kind, that the results will be comparable.
//
// If a program wishes to emit an event which is not described by an
// existing Kind value, a new Kind should be written to fit the bill.  The
// new value should be reusable across other programs with similar
// requirements and should not be particular to the language or framework
// used.
type Event_Kind int32

const (
	// Server reads the beginning of a request.  The server has received
	// sufficient data from the client to determine which Trace
	// transaction the request should be attributed to, if any.  If the
	// protocol differentiates between a metadata preamble and a payload
	// that follows, this event is emitted immediately after the entire
	// metadata has been received.
	//
	// For an HTTP request, this would be when the transport has presented
	// the request URI and headers are presented to the application.
	Event_REQUEST_HEAD_RECEIVED Event_Kind = 20
	// Server finishes reading the last of the request body.
	//
	// For an HTTP request, this would be when the transport has presented
	// the last of the request body to the application and notified it
	// that no more body data will be received.  Trailers may be yet to
	// come.
	Event_REQUEST_BODY_RECEIVED Event_Kind = 21
	// Server responds to a request.  There has not yet been any direct
	// communication to the client about the client's request on the
	// application layer, but the server will change that immediately
	// after generating this event.  Transport-layer acknowledgement of
	// data receipt does not trigger this event.
	//
	// For an HTTP response, this would be when the status code and
	// headers are presented to the HTTP transport, before any bytes are
	// written to the wire.
	Event_RESPONSE_HEAD_PREPARED Event_Kind = 30
	// Server has sent the last of the response body to the client.
	//
	// For an HTTP response, this would be when the last of the response
	// body has been accepted by the HTTP transport, and the application
	// has notified the transport that no more body data will be sent.
	Event_RESPONSE_BODY_SENT Event_Kind = 31
	// Client initiates a request.  There has been no indication given to
	// the outside world that this particular request is about to take
	// place.  The application knows enough about the request to begin
	// making externally-visible actions.
	//
	// For an HTTP request, this would be when the request URI and headers
	// are presented to the HTTP transport, before any bytes are written
	// to the wire.  The hostname may still need to be resolved, a TCP
	// connection may still need to be established, a TLS handshake may
	// still need to take place.
	Event_REQUEST_HEAD_PREPARED Event_Kind = 40
	// Client finishes the externally-visible actions required for the
	// request.
	//
	// For an HTTP request, this would be when the last of the request
	// body has been accepted by the HTTP transport, and the application
	// has notified the transport that no more body data will be sent.
	Event_REQUEST_BODY_SENT Event_Kind = 41
	// Client reads the beginning of the response.  The response metadata
	// has been read and is ready to be presented to the application's
	// business logic, giving some initial indication of if the RPC
	// succeeded.  The response body has not yet been read.
	//
	// For an HTTP response, this would be when the client's HTTP
	// transport has read and decoded the full response headers from the
	// wire and is presenting them to the application, but before the
	// response body has been consumed.
	Event_RESPONSE_HEAD_RECEIVED Event_Kind = 50
	// Client finishes reading the last of the response body.
	//
	// For an HTTP response, this would be when the transport has
	// presented the last of the response body to the application and
	// notified it that no more body data will be received.  Trailers may
	// be yet to come.
	Event_RESPONSE_BODY_RECEIVED Event_Kind = 51
)

var Event_Kind_name = map[int32]string{
	20: "REQUEST_HEAD_RECEIVED",
	21: "REQUEST_BODY_RECEIVED",
	30: "RESPONSE_HEAD_PREPARED",
	31: "RESPONSE_BODY_SENT",
	40: "REQUEST_HEAD_PREPARED",
	41: "REQUEST_BODY_SENT",
	50: "RESPONSE_HEAD_RECEIVED",
	51: "RESPONSE_BODY_RECEIVED",
}
var Event_Kind_value = map[string]int32{
	"REQUEST_HEAD_RECEIVED":  20,
	"REQUEST_BODY_RECEIVED":  21,
	"RESPONSE_HEAD_PREPARED": 30,
	"RESPONSE_BODY_SENT":     31,
	"REQUEST_HEAD_PREPARED":  40,
	"REQUEST_BODY_SENT":      41,
	"RESPONSE_HEAD_RECEIVED": 50,
	"RESPONSE_BODY_RECEIVED": 51,
}

func (x Event_Kind) Enum() *Event_Kind {
	p := new(Event_Kind)
	*p = x
	return p
}
func (x Event_Kind) String() string {
	return proto.EnumName(Event_Kind_name, int32(x))
}
func (x *Event_Kind) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_Kind_value, data, "Event_Kind")
	if err != nil {
		return err
	}
	*x = Event_Kind(value)
	return nil
}

// https://www.iana.org/assignments/http-methods/http-methods.xhtml
type ExtraHTTP_Method int32

const (
	// invalid, default value
	ExtraHTTP_UNKNOWN ExtraHTTP_Method = 0
	// https://tools.ietf.org/html/rfc7231#section-4.3.1  safe, idempotent
	ExtraHTTP_GET ExtraHTTP_Method = 1
	// https://tools.ietf.org/html/rfc7231#section-4.3.2  safe, idempotent
	ExtraHTTP_HEAD ExtraHTTP_Method = 2
	// https://tools.ietf.org/html/rfc7231#section-4.3.3
	ExtraHTTP_POST ExtraHTTP_Method = 3
	// https://tools.ietf.org/html/rfc7231#section-4.3.4  idempotent
	ExtraHTTP_PUT ExtraHTTP_Method = 4
	// https://tools.ietf.org/html/rfc7231#section-4.3.5  idempotent
	ExtraHTTP_DELETE ExtraHTTP_Method = 5
	// https://tools.ietf.org/html/rfc7231#section-4.3.6
	ExtraHTTP_CONNECT ExtraHTTP_Method = 6
	// https://tools.ietf.org/html/rfc7231#section-4.3.7  safe, idempotent
	ExtraHTTP_OPTIONS ExtraHTTP_Method = 7
	// https://tools.ietf.org/html/rfc7231#section-4.3.8  safe, idempotent
	ExtraHTTP_TRACE ExtraHTTP_Method = 8
	// https://tools.ietf.org/html/rfc5789
	ExtraHTTP_PATCH ExtraHTTP_Method = 9
)

var ExtraHTTP_Method_name = map[int32]string{
	0: "UNKNOWN",
	1: "GET",
	2: "HEAD",
	3: "POST",
	4: "PUT",
	5: "DELETE",
	6: "CONNECT",
	7: "OPTIONS",
	8: "TRACE",
	9: "PATCH",
}
var ExtraHTTP_Method_value = map[string]int32{
	"UNKNOWN": 0,
	"GET":     1,
	"HEAD":    2,
	"POST":    3,
	"PUT":     4,
	"DELETE":  5,
	"CONNECT": 6,
	"OPTIONS": 7,
	"TRACE":   8,
	"PATCH":   9,
}

func (x ExtraHTTP_Method) Enum() *ExtraHTTP_Method {
	p := new(ExtraHTTP_Method)
	*p = x
	return p
}
func (x ExtraHTTP_Method) String() string {
	return proto.EnumName(ExtraHTTP_Method_name, int32(x))
}
func (x *ExtraHTTP_Method) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ExtraHTTP_Method_value, data, "ExtraHTTP_Method")
	if err != nil {
		return err
	}
	*x = ExtraHTTP_Method(value)
	return nil
}

// An Event represents a single Trace-worthy event.  This includes RPC
// lifecycle events (client started to send a request, server finishes sending
// a response), and application-specific custom events.
type Event struct {
	// Lifecycle event this message is attached to
	Kind *Event_Kind `protobuf:"varint,1,opt,name=kind,enum=code.justin.tv.release.trace.pbmsg.Event_Kind" json:"kind,omitempty"`
	// Unix epoch time in nanoseconds, as measured by the process
	Time *int64 `protobuf:"fixed64,2,opt,name=time" json:"time,omitempty"`
	// FQDN of the process's host
	Hostname *string `protobuf:"bytes,3,opt,name=hostname" json:"hostname,omitempty"`
	// Service name of the process
	Svcname *string `protobuf:"bytes,4,opt,name=svcname" json:"svcname,omitempty"`
	// PID of the process
	Pid *int32 `protobuf:"varint,5,opt,name=pid" json:"pid,omitempty"`
	// 128-bit identifier for the entire transaction.  This field is sent as
	// two 64-bit integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,6,rep,packed,name=transaction_id" json:"transaction_id,omitempty"`
	// Identifier for a single RPC span (one request leading to one response).
	// Each level of the distributed call stack adds a new element to the path
	// field.  The value at each level is the (zero-indexed) number of
	// outbound RPC requests made at that level.
	Path []uint32 `protobuf:"varint,7,rep,packed,name=path" json:"path,omitempty"`
	// Additional protocol-specific information
	Extra            *Extra `protobuf:"bytes,8,opt,name=extra" json:"extra,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}

func (m *Event) GetKind() Event_Kind {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return Event_REQUEST_HEAD_RECEIVED
}

func (m *Event) GetTime() int64 {
	if m != nil && m.Time != nil {
		return *m.Time
	}
	return 0
}

func (m *Event) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *Event) GetSvcname() string {
	if m != nil && m.Svcname != nil {
		return *m.Svcname
	}
	return ""
}

func (m *Event) GetPid() int32 {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return 0
}

func (m *Event) GetTransactionId() []uint64 {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func (m *Event) GetPath() []uint32 {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Event) GetExtra() *Extra {
	if m != nil {
		return m.Extra
	}
	return nil
}

// An Extra describes protocol-specific information to be associated with an
// Event.
type Extra struct {
	// The address of the peer.  This could be an ipv4:port pair, [ipv6]:port
	// pair, or hostname:port pair for TCP/UDP-based protocols, a bare IP
	// address or hostname for IP- based protocols, or a path to a unix domain
	// socket.
	//
	// This field is NOT an attempt to identify the client, e.g. via the HTTP
	// X-Forwarded-For header.
	Peer *string `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	// Additional HTTP-specific information for the Event.
	Http             *ExtraHTTP `protobuf:"bytes,2,opt,name=http" json:"http,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *Extra) Reset()         { *m = Extra{} }
func (m *Extra) String() string { return proto.CompactTextString(m) }
func (*Extra) ProtoMessage()    {}

func (m *Extra) GetPeer() string {
	if m != nil && m.Peer != nil {
		return *m.Peer
	}
	return ""
}

func (m *Extra) GetHttp() *ExtraHTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

// An ExtraHTTP describes HTTP-specific information to be associated with an
// Event.
type ExtraHTTP struct {
	// Status code of HTTP response.  Common values will include 200 or 404.
	// Values less than zero indicate an error observed by the client which
	// caused it to give up on the request before getting a status code from
	// the server.
	StatusCode *int32 `protobuf:"zigzag32,1,opt,name=status_code" json:"status_code,omitempty"`
	// Method of HTTP request.
	Method *ExtraHTTP_Method `protobuf:"varint,2,opt,name=method,enum=code.justin.tv.release.trace.pbmsg.ExtraHTTP_Method" json:"method,omitempty"`
	// Path of the HTTP request.  This is only the path - the scheme,
	// hostname, query, and fragment are not included.
	UriPath          *string `protobuf:"bytes,16,opt,name=uri_path" json:"uri_path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExtraHTTP) Reset()         { *m = ExtraHTTP{} }
func (m *ExtraHTTP) String() string { return proto.CompactTextString(m) }
func (*ExtraHTTP) ProtoMessage()    {}

func (m *ExtraHTTP) GetStatusCode() int32 {
	if m != nil && m.StatusCode != nil {
		return *m.StatusCode
	}
	return 0
}

func (m *ExtraHTTP) GetMethod() ExtraHTTP_Method {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return ExtraHTTP_UNKNOWN
}

func (m *ExtraHTTP) GetUriPath() string {
	if m != nil && m.UriPath != nil {
		return *m.UriPath
	}
	return ""
}

// An UnusedExtra describes protocol-specific information to be associated
// with an Event.  This message is not yet ready for use, meaning that the
// field names, identities, and numbers are subject to change!
type UnusedExtra struct {
	// written by an engineer - "string" means utf-8 encoded, which should be
	// fine?
	Text          *string `protobuf:"bytes,20,opt,name=text" json:"text,omitempty"`
	TextTruncated *bool   `protobuf:"varint,1020,opt,name=text_truncated" json:"text_truncated,omitempty"`
	// if there's a payload, how big is it?
	PayloadSize *int64 `protobuf:"varint,21,opt,name=payload_size" json:"payload_size,omitempty"`
	// request uri
	HttpUri          *string `protobuf:"bytes,41,opt,name=http_uri" json:"http_uri,omitempty"`
	HttpUriTruncated *bool   `protobuf:"varint,1041,opt,name=http_uri_truncated" json:"http_uri_truncated,omitempty"`
	// headers, partial list
	HttpHeader []*UnusedExtra_KV `protobuf:"bytes,43,rep,name=http_header" json:"http_header,omitempty"`
	// if there are headers that we expect to be very long, we may want to
	// pull them out into their own fields so we can note when we truncate
	// them
	HttpReferer          *string `protobuf:"bytes,44,opt,name=http_referer" json:"http_referer,omitempty"`
	HttpRefererTruncated *bool   `protobuf:"varint,1044,opt,name=http_referer_truncated" json:"http_referer_truncated,omitempty"`
	XXX_unrecognized     []byte  `json:"-"`
}

func (m *UnusedExtra) Reset()         { *m = UnusedExtra{} }
func (m *UnusedExtra) String() string { return proto.CompactTextString(m) }
func (*UnusedExtra) ProtoMessage()    {}

func (m *UnusedExtra) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

func (m *UnusedExtra) GetTextTruncated() bool {
	if m != nil && m.TextTruncated != nil {
		return *m.TextTruncated
	}
	return false
}

func (m *UnusedExtra) GetPayloadSize() int64 {
	if m != nil && m.PayloadSize != nil {
		return *m.PayloadSize
	}
	return 0
}

func (m *UnusedExtra) GetHttpUri() string {
	if m != nil && m.HttpUri != nil {
		return *m.HttpUri
	}
	return ""
}

func (m *UnusedExtra) GetHttpUriTruncated() bool {
	if m != nil && m.HttpUriTruncated != nil {
		return *m.HttpUriTruncated
	}
	return false
}

func (m *UnusedExtra) GetHttpHeader() []*UnusedExtra_KV {
	if m != nil {
		return m.HttpHeader
	}
	return nil
}

func (m *UnusedExtra) GetHttpReferer() string {
	if m != nil && m.HttpReferer != nil {
		return *m.HttpReferer
	}
	return ""
}

func (m *UnusedExtra) GetHttpRefererTruncated() bool {
	if m != nil && m.HttpRefererTruncated != nil {
		return *m.HttpRefererTruncated
	}
	return false
}

// if we use proto3 we can just use maps
type UnusedExtra_KV struct {
	// option map_entry = true;
	Key              *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *UnusedExtra_KV) Reset()         { *m = UnusedExtra_KV{} }
func (m *UnusedExtra_KV) String() string { return proto.CompactTextString(m) }
func (*UnusedExtra_KV) ProtoMessage()    {}

func (m *UnusedExtra_KV) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *UnusedExtra_KV) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// An EventSet is a list of Events.  It may be used when sending multiple
// events in a datagram, or when saving them to disk.  There is no codified or
// implied relation between Events grouped into an EventSet.
type EventSet struct {
	// List of Events
	Event            []*Event `protobuf:"bytes,1,rep,name=event" json:"event,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *EventSet) Reset()         { *m = EventSet{} }
func (m *EventSet) String() string { return proto.CompactTextString(m) }
func (*EventSet) ProtoMessage()    {}

func (m *EventSet) GetEvent() []*Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func init() {
	proto.RegisterEnum("code.justin.tv.release.trace.pbmsg.Event_Kind", Event_Kind_name, Event_Kind_value)
	proto.RegisterEnum("code.justin.tv.release.trace.pbmsg.ExtraHTTP_Method", ExtraHTTP_Method_name, ExtraHTTP_Method_value)
}
