package twitchstats

import (
	"net/http"
	"time"
)

type Stats struct {
	MixPanelToken string
	Client        *http.Client
	globalData    map[string]interface{}
	Verbose       bool
}

// Add adds global event info to the stats instance.
func (s *Stats) Add(name string, value interface{}) {
	if s.globalData == nil {
		s.globalData = make(map[string]interface{})
	}

	s.globalData[name] = value
}

// NewEvent return a new event instance.
func (s *Stats) NewEvent(eventName string) *Event {
	if s.globalData == nil {
		s.globalData = make(map[string]interface{})
	}

	data := make(map[string]interface{})

	event := &Event{
		stats:         s,
		data:          data,
		eventName:     eventName,
		startTime:     time.Now(),
		subTaskStart:  make(map[string]time.Time),
		subTaskFinish: make(map[string]time.Time),
	}

	event.Start()

	return event
}
