## Using

```ruby
# Vagrantfile
Vagrant.configure('2') do |config|
	config.vm.box = 'godev'
	config.vm.box_version = '~> 1.11.3.0'
	config.vm.box_url = 'http://devtools-vagrant-images.s3.amazonaws.com/godev'
	config.ssh.forward_agent = true
end
```

## Contributing
To build a new image:

```bash
brew install packer
packer build packer.json
```

To publish, add the new file to the version list in the `godev` manifest and upload it to http://devtools-vagrant-images.s3.amazonaws.com/godev

```bash
aws s3 cp godev-0.0.0-0000000000.box s3://devtools-vagrant-images/godev/godev-0.0.0-0000000000.box --profile twitch-science-aws
aws s3 cp godev s3://devtools-vagrant-images/godev --content-type application/json --profile twitch-science-aws
```
