set -e -x

wget https://storage.googleapis.com/golang/go$GOVERSION.linux-amd64.tar.gz
echo "$GOSHA256  go$GOVERSION.linux-amd64.tar.gz" | sha256sum --check
tar -C /usr/local -xzf go$GOVERSION.linux-amd64.tar.gz

echo '
export PATH="/usr/local/go/bin:/go/bin/:$PATH"
export GOPATH="/go"
' >> /home/vagrant/.profile

. /home/vagrant/.profile

apt-get -y install git mercurial
go get github.com/golang/dep/cmd/dep

echo '
sudo chown -R vagrant:vagrant $GOPATH # ensures synced_folder is never owned by root
' >> /home/vagrant/.profile

chown -R vagrant:vagrant /go /home/vagrant/.ssh
rm -rf /home/vagrant/.cache/go-build
