## Using

```ruby
# Vagrantfile
Vagrant.configure('2') do |config|
	config.vm.box = 'pythondev'
	config.vm.box_version = '~> 2.7.6.0'
	config.vm.box_url = 'http://devtools-vagrant-images.s3.amazonaws.com/pythondev'
	config.ssh.forward_agent = true
end
```

## Contributing

When creating a new box version, add the new file to the version list in the `pythondev` manifest and upload it to http://devtools-vagrant-images.s3.amazonaws.com/pythondev

```bash
aws s3 cp pythondev s3://devtools-vagrant-images/pythondev --content-type application/json --profile twitch-aws
aws s3 cp pythondev-*.box s3://devtools-vagrant-images/pythondev/ --profile twitch-aws
```
