## Using

```ruby
# Vagrantfile
Vagrant.configure('2') do |config|
	config.vm.box = 'rubydev'
	config.vm.box_version = '~> 2.3.0.0'
	config.vm.box_url = 'http://devtools-vagrant-images.s3.amazonaws.com/rubydev'
	config.ssh.forward_agent = true
end
```

## Contributing

When creating a new box version, update the `rubydev` manifest and upload it to http://devtools-vagrant-images.s3.amazonaws.com/rubydev

```bash
aws s3 cp rubydev-*.box s3://devtools-vagrant-images/rubydev/rubydev-*.box --profile twitch-aws
aws s3 cp rubydev s3://devtools-vagrant-images/rubydev --content-type application/json --profile twitch-aws
```