package main

import (
	"flag"
	"fmt"
	"log"

	"git-aws.internal.justin.tv/tarrant/poor-man-queue"
	"github.com/hashicorp/consul/api"
)

func main() {
	var address string

	flag.StringVar(&address, "api", "localhost:8500", "consul api to hit")
	flag.Parse()

	config := api.DefaultConfig()
	config.Address = address

	client, err := api.NewClient(config)
	if err != nil {
		log.Fatal(err)
	}

	queue, err := poormanqueue.NewConsulQueue("/test/foobar", client)
	if err != nil {
		log.Fatal(err)
	}

	item, err := queue.Dequeue()
	if err != nil {
		log.Fatal(err)
	}

	fmt.Printf("Got %s from queue\n", *item)

	err = queue.Enqueue(*item)
	if err != nil {
		log.Fatal(err)
	}

	fmt.Printf("Put %s back in the queue\n", *item)
}
