package poormanqueue

import "sync"

type LocalQueue struct {
	data []string
	lock sync.Mutex
}

func NewLocalQueue() *LocalQueue {
	return &LocalQueue{
		data: []string{},
		lock: sync.Mutex{},
	}
}

func (q *LocalQueue) Enqueue(items ...string) error {
	q.lock.Lock()
	defer q.lock.Unlock()

	q.data = append(q.data, items...)
	return nil
}

func (q *LocalQueue) Dequeue() (*string, error) {
	q.lock.Lock()
	defer q.lock.Unlock()

	var res *string

	if len(q.data) >= 1 {
		res = &(q.data[0])
		q.data = q.data[1:]
	}

	return res, nil
}

func (q *LocalQueue) Drain() (*string, int, error) {
	q.lock.Lock()
	defer q.lock.Unlock()

	var res *string

	count := len(q.data)
	if count >= 1 {
		res = &(q.data[0])
		q.data = []string{}
	}

	return res, count, nil
}
