package poormanqueue

import "testing"

func TestQueueOrder(t *testing.T) {
	var err error

	l := NewLocalQueue()

	err = l.Enqueue("item1")
	if err != nil {
		t.Fatalf("Error queueing item1: %v", err)
	}

	err = l.Enqueue("item2")
	if err != nil {
		t.Fatalf("Error queueing item2: %v", err)
	}

	item1, err := l.Dequeue()
	if err != nil {
		t.Fatalf("Error dequeueing item1: %v", err)
	}

	item2, err := l.Dequeue()
	if err != nil {
		t.Fatalf("Error dequeueing item2: %v", err)
	}

	if item1 != nil && *item1 != "item1" {
		t.Fail()
	}

	if item2 != nil && *item2 != "item2" {
		t.Fail()
	}
}
