Runtime
=======

Problem
-------

* Projects run in unknown runtime environments
* Requires hopping between multiple repos (puppet, app)
* Multiple configuration systems

Proposal
--------

* Standardized runtime environment
    - linux container, ami, system image, or other contained setup?
* Comes preinstalled with:
    - consul agent
    - barrel
    - ???
* Tool inside reads a config file (likely served via userdata)
    - Configures application based upon standard config. e.g.:

```
{
  "ruby_version": "2.9",
  "applications": [
    {
      "repo": "web/foo1",
      "extra_env": "FOO_MODE=collector",
      "dependencies": "libmagic"
    },
    {
      "repo": "release/somecoolthing"
    }
  ]
}
```

* spins up envconsul to create config files
    - eventual tools for creating new environments and their configs
* courier to install repos mentioned in applications list
    - post-install.sh? (almost definitely not)
* exposes standard env variables:
    - APPDIR
    - ENVIRONMENT
    - APP_NAME
    - GO_MAXPROCS=`facter processorcount`
    - ...
