module "web" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//web"
  # The prefix for hostnames and the consul env:
  env  = "external-staging-1"
  # Who it should ssh to to provision the machine:
  owner = "devtools"
  email = "devtools@twitch.tv"
  public_security_group = "${aws_security_group.public_security_group.id}"
  public = 1
}

resource "aws_security_group" "public_security_group" {
    name = "external-staging-1-xsola-security-group"
    description = "Allow xsola access external-staging-1"
    vpc_id="vpc-1e13b17b"

    ingress {
        from_port = 80
        to_port = 80
        protocol = "tcp"
        cidr_blocks = [
          "159.255.220.240/28",
          "185.30.20.16/29",
          "185.30.21.0/24",
          "185.30.21.16/29",
          "173.196.181.234/32",
          "185.30.23.18/32",
          "92.243.26.27/32"
        ]
    }

    ingress {
        from_port = 443
        to_port = 443
        protocol = "tcp"
        cidr_blocks = [
          "159.255.220.240/28",
          "185.30.20.16/29",
          "185.30.21.0/24",
          "185.30.21.16/29",
          "173.196.181.234/32",
          "185.30.23.18/32",
          "92.243.26.27/32"
        ]
    }
}

provider "consul" {
  address = "consul.internal.justin.tv"
  datacenter = "sfo01"
    scheme = "http"

}

provider "aws" {
  region = "us-west-2"
}

output "url" {
  value = "${module.web.url}"
}
