module "web" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//web"
  # The prefix for hostnames and the consul env:
  env  = "external-staging-2"
  # Who it should ssh to to provision the machine:
  owner = "devtools"
  email = "devtools@twitch.tv"
  public_security_group = "${aws_security_group.public_security_group.id}"
  public = 1
}

resource "aws_security_group" "public_security_group" {
    name = "external-staging-2-xsola-security-group"
    description = "Allow xsola access external-staging-2"
    vpc_id="vpc-1e13b17b"

    ingress {
        from_port = 80
        to_port = 80
        protocol = "tcp"
        cidr_blocks = [
          "207.171.180.101/32",
          "207.171.180.102/31",
          "207.171.180.104/32",
          "207.171.191.52/32",
          "207.171.191.60/31",
          "207.171.191.62/32",
          "54.240.196.0/24",
          "54.240.197.0/24"
        ]
    }

    ingress {
        from_port = 443
        to_port = 443
        protocol = "tcp"
        cidr_blocks = [
          "207.171.180.101/32",
          "207.171.180.102/31",
          "207.171.180.104/32",
          "207.171.191.52/32",
          "207.171.191.60/31",
          "207.171.191.62/32",
          "54.240.196.0/24",
          "54.240.197.0/24"
        ]
    }
}

provider "consul" {
  address = "consul.internal.justin.tv"
  datacenter = "sfo01"
    scheme = "http"

}

provider "aws" {
  region = "us-west-2"
}

output "url" {
  value = "${module.web.url}"
}
