module "web" {
    source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//web"
	# The prefix for hostnames and the consul env:
	env  = "staging-2"
	# Who it should ssh to to provision the machine:
    owner = "tarrant"
	email = "tarrant@twitch.tv"
}


provider "consul" {
    address = "consul.internal.justin.tv"
    datacenter = "sfo01"
    scheme = "http"

}

provider "aws" {
	region = "us-west-2"
}

output "url" {
	value = "${module.web.url}"
}
