variable "hard_ids" {
    default {
        r53                        = "ZRG00SM48517Z"
        twitch_r53                 = "Z127RUWUPOFGHX"
        public_twitch_r53          = "ZL2XLO1TDFXZB"
        prod_vpc                   = "vpc-0213b167"
        dev_vpc                    = "vpc-1e13b17b"
        dev_twitch_security_group  = "sg-f1edb194"
        prod_twitch_security_group = "sg-27d18d42"

        prod_db_subnets = "prod"
        dev_db_subnets  = "dev"

        prod_avail = "subnet-faa4239f,subnet-88a207ff,subnet-9c4ab1c5"
        dev_avail = "subnet-d4a423b1,subnet-67ad0810,subnet-894ab1d0"
        dev_avail_0 = "subnet-d4a423b1"
    }
}

# AMIs are by region, so this should be a map
variable "ami" {
    default {
        base = "ami-1d1e0f2d"
        us-west-2 = "ami-1d1e0f2d"
    }
}

output "ami" {
	value = "${var.ami.base}"
}

output "dev_avail_zone_0" {
    value = "${var.hard_ids.dev_avail_0}"
}

output "dev_twitch_security_group" {
	value = "${var.hard_ids.dev_twitch_security_group}"
}

output "prod_twitch_security_group" {
	value = "${var.hard_ids.prod_twitch_security_group}"
}

output "r53" {
	value = "${var.hard_ids.r53}"
}

output "twitch_r53" {
	value = "${var.hard_ids.twitch_r53}"
}

output "public_twitch_r53" {
	value = "${var.hard_ids.public_twitch_r53}"
}

output "prod_vpc" {
	value = "${var.hard_ids.prod_vpc}"
}

output "dev_vpc" {
    value = "${var.hard_ids.dev_vpc}"
}

output "dev_avail_subnets" {
    value = "${var.hard_ids.dev_avail}"
}

output "dev_subnet_a" {
    value = "subnet-d4a423b1"
}

output "dev_subnet_b" {
    value = "subnet-67ad0810"
}

output "dev_subnet_c" {
    value = "subnet-894ab1d0"
}

output "dev_avail" {
    value = "${var.hard_ids.dev_avail}"
}

output "dev_avail_zones" {
    value = "us-west-2a,us-west-2b,us-west-2c"
}

output "dev_db_subnets" {
    value = "dev"
}

output "prod_db_subnets" {
    value = "prod"
}

output "prod_avail" {
  value = "${var.hard_ids.prod_avail}"
}

output "prod_avail_subnets" {
    value = "subnet-faa4239f,subnet-88a207ff,subnet-9c4ab1c5"
}

output "prod_subnet_a" {
    value = "subnet-faa4239f"
}

output "prod_subnet_b" {
    value = "subnet-88a207ff"
}

output "prod_subnet_c" {
    value = "subnet-9c4ab1c5"
}
