Build
=====

1. Create a github application. You will need the client_id and client_secret
   to feed into the build module.

2. Create an instance of the module:

  ```
  module "build" {
    source = "../../../terraform//build"
    # The prefix for hostnames and the consul env:
    env  = "tarrant-1"
  
    owner = "tarrant <tarrant@twitch.tv>"
    github_client_id = "<github_client_id>"
    github_client_secret = "<github_client_secret>"
  }
  
  provider "consul" {
    address = "consul.internal.justin.tv"
    datacenter = "sfo01"
  }
  
  provider "aws" {
    region = "us-west-2"
  }
  
  output "url" {
    value = "${module.build.url}"
  }
  
  output "callback_url" { 
    value = "Set your github application callback to: ${module.build.callback_url}"
  }
  ```

3. Go update the github application you created above. The callback url should
   match the output of terraform.

4. Get the pg conn info and run goose up. (TODO: explain how to do this)
