module "base" {
    source = "../base"
}

variable env {}
variable owner {}
variable count {
  default = "1"
}

variable github_client_id {}
variable github_client_secret {}

variable dev_avail {
    default {
        zone0 = "subnet-d4a423b1"
        zone1 = "subnet-67ad0810"
        zone2 = "subnet-894ab1d0"
        # Hack to make this work with larger counts
        zone3  = "subnet-d4a423b1"
        zone4  = "subnet-67ad0810"
        zone5  = "subnet-894ab1d0"
        zone6  = "subnet-d4a423b1"
        zone7  = "subnet-67ad0810"
        zone8  = "subnet-894ab1d0"
        zone9  = "subnet-d4a423b1"
        zone10 = "subnet-67ad0810"
        zone11 = "subnet-894ab1d0"
        zone12 = "subnet-d4a423b1"
        zone13 = "subnet-67ad0810"
        zone14 = "subnet-894ab1d0"
        zone15 = "subnet-d4a423b1"
        zone16 = "subnet-67ad0810"
        zone17 = "subnet-894ab1d0"
        zone18 = "subnet-d4a423b1"
        zone19 = "subnet-67ad0810"
        zone20 = "subnet-894ab1d0"
    }
}

################
# Skadi Server #
################

module "skadi-instance" {
    source = "../puppet_instance"
    hostname_prefix = "${var.env}-skadi"
    cluster = "skadi"
    owner = "${var.owner}"
    facts = "app_env=${var.env}"
}

######
# DB #
######

resource "aws_db_subnet_group" "skadi" {
	name = "skadi-${var.env}"
	description = "DB subnet for skadi; env: '${var.env}'"

	subnet_ids = ["${var.dev_avail.zone0}", "${var.dev_avail.zone1}", "${var.dev_avail.zone2}"]
} 

resource "aws_db_instance" "skadi" {
	identifier = "skadi-${var.env}"
	allocated_storage = 5
	engine = "postgres"
	engine_version = "9.3.5"
	instance_class = "db.t2.medium"
	multi_az = true
	name = "skadi"
	port = 5432
	username = "skadi"
	password = "ba0238bb003q9z7768l"
	vpc_security_group_ids = ["${module.base.dev_twitch_security_group}"]
	db_subnet_group_name = "${aws_db_subnet_group.skadi.name}"
	parameter_group_name = "default.postgres9.3"
}

##################################
# Register environment in consul #
##################################

resource "consul_keys" "skadi-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/release/skadi/${var.env.name}"
        value = "{}"
        delete = true
    }
}

###############################
# Configure the App in Consul #
###############################

resource "consul_keys" "skadi-db-password" {
    datacenter = "us-west2"
    key {
        name = "skadi-db-password"
        path = "settings/skadi/${var.env.name}/pg-conn-info"
        value = "host=${aws_db_instance.skadi.address} port=5432 user=skadi password=ba0238bb003q9z7768l"
        delete = true
    }
}

resource "consul_keys" "skadi-github" {
    datacenter = "us-west2"
    key {
        name = "skadi-github-id"
        path = "settings/skadi/${var.env.name}/github-client-id"
        value = "${var.github_client_id}"
        delete = true
    }

    key {
        name = "skadi-github-secret"
        path = "settings/skadi/${var.env.name}/github-client-secret"
        value = "${var.github_client_secret}"
        delete = true
    }
}

##########
# Output #
##########

output "url" {
  value = "http://${module.skadi-instance.fqdn}:8080/"
}

output "callback_url" {
  value = "http://${module.skadi-instance.fqdn}:8080/github_oauth_callback"
}
