module "base" {
    source = "../base"
}

# Should be moved to a base module
provider "aws" {
  region = "us-west-2"
}

#####################
# Production Consul #
#####################

variable consul {
  default {
    count = 5
  }
}

resource "aws_route53_record" "private-consul" {
  zone_id = "${module.base.r53}"
  name = "clean-consul-servers.prod.us-west2.justin.tv"
  type = "A"
  ttl = "300"
  records = ["${aws_instance.consul-servers.*.private_ip}"]
}

resource "aws_instance" "consul-servers" {
  lifecycle {
    prevent_destroy = false

  }
  count = "${var.consul.count}"
  ami = "ami-331e3103"
  instance_type = "c3.4xlarge"
  subnet_id = "${element(split(",", module.base.prod_avail), count.index % 3)}"
  security_groups = ["${module.base.prod_twitch_security_group}"]
  source_dest_check = false
  monitoring = true
  root_block_device {
    volume_size = "40"

  }
  user_data = <<END_OF_STRING
#cloud-config
hostname: "consul-server-${count.index}"
fqdn: "consul-server-${count.index}.prod.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=consul" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=production" > /etc/facter/facts.d/twitch_environment.txt
 - echo "app_env=production" > /etc/facter/facts.d/app_env.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppetmaster-6dbb10.sfo01.justin.tv
END_OF_STRING
  tags {
    Name = "consul-server-${count.index}.prod.us-west2.justin.tv"
  }
}

resource "aws_route53_record" "consul-servers" {
  count = "${var.consul.count}"
   zone_id = "${module.base.r53}"
   name = "consul-server-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${element(aws_instance.consul-servers.*.private_ip, count.index)}"]
}
