provider "aws" {
	region = "us-west-2"
}

variable avail {
    default {
        zone0 = "subnet-d4a423b1"
        zone1 = "subnet-67ad0810"
        zone2 = "subnet-894ab1d0"
    }
}

resource "aws_security_group" "development_twitch_subnet" {
    name = "twitch_subnets"
    description = "Allow access from the twitch subnet (development)"
	vpc_id="vpc-1e13b17b"

    ingress {
    to_port = 0
    from_port = 0
		protocol = "-1"
		cidr_blocks = [
		 	"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"127.0.0.1/32",

      // Twitch Office:
			"38.99.10.97/32",
                        "38.104.129.210/32",
			"192.168.0.0/16",

      // APAC
                        "45.113.128.0/22",
                        "103.53.48.0/22",
      // Datacenters
                        "52.223.192.0/18",
                        "52.223.240.0/20"
			]
    }

}

resource "aws_db_subnet_group" "dev" {
    name = "dev"
    description = "Our production group of subnets"
    subnet_ids = ["${var.avail.zone0}", "${var.avail.zone1}", "${var.avail.zone2}"]
}
