module "base" {
    source = "../base"
}

# Should be moved to a base module
provider "aws" {
	region = "us-west-2"
}

variable "eni_ips" {
  default {
    ip0 = "10.192.67.85"
    ip1 = "10.192.69.171"
    ip2 = "10.192.75.166"
  }
}

#########
# Clean #
#########

resource "aws_instance" "dns-servers" {
  count = 3
  # Force an ami version to prevent terraform from rebuilding:
  ami = "ami-331e3103"
  instance_type = "c4.large"
  subnet_id = "${element(split(",", module.base.prod_avail), count.index % 3)}"
  security_groups = ["${module.base.prod_twitch_security_group}"]
  tags {
    Name = "dns-${count.index}.prod.us-west2.justin.tv"
  }
  user_data = <<END_OF_STRING
#cloud-config
hostname: "dns-${count.index}"
fqdn: "dns-${count.index}.prod.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=aws-dns-server" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=production" > /etc/facter/facts.d/twitch_environment.txt
 - echo "app_env=production" > /etc/facter/facts.d/app_env.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppetmaster-6dbb10.sfo01.justin.tv
END_OF_STRING
}

resource "aws_route53_record" "dns-servers" {
  count = 3
  zone_id = "${module.base.r53}"
  name = "dns-${count.index}.prod.us-west2.justin.tv"
  type = "A"
  ttl = "300"
  records = ["${element(aws_instance.dns-servers.*.private_ip, count.index)}"]
} 

resource "aws_network_interface" "dns-servers" {
  count = 3
  security_groups = ["${module.base.prod_twitch_security_group}"]
  subnet_id = "${element(split(",", module.base.prod_avail), count.index % 3)}"
  private_ips = ["${lookup(var.eni_ips, concat("ip", count.index))}"]
  attachment {
    instance     = "${element(aws_instance.dns-servers.*.id, count.index)}"
    device_index = "1"
  }
}
