module "base" {
    source = "../base"
}

provider "aws" {
    region = "us-west-2"
}

###################
# Docker Registry #
###################

variable "docker-registry" {
	default {
		count = 1
	}
}

resource "aws_instance" "docker-registry" {
	count = "${var.docker-registry.count}"
	ami = "ami-2f82b11f"
	instance_type = "c3.xlarge"
	subnet_id = "subnet-9c4ab1c5"
	security_groups = ["${module.base.prod_twitch_security_group}"]
  user_data = <<END_OF_STRING
#cloud-config
hostname: "docker-registry-${count.index}"
fqdn: "docker-registry-${count.index}.prod.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - echo "cluster=docker-registry" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=production" > /etc/facter/facts.d/twitch_environment.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "app_env=production" > /etc/facter/facts.d/app_env.txt
 - puppet agent --test
END_OF_STRING
	tags {
		Name = "docker-registry-${count.index}.prod.us-west2.justin.tv"
	}
}

resource "aws_route53_record" "docker-registry" {
   count = "${var.docker-registry.count}"
   zone_id = "${module.base.r53}"
   name = "docker-registry-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${element(aws_instance.docker-registry.*.private_ip, count.index)}"]
}

resource "aws_route53_record" "private-docker-registry" {
   zone_id = "${module.base.r53}"
   name = "docker-registry.prod.us-west2.justin.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.docker.dns_name}"]
}

resource "aws_elb" "docker" {
  name = "docker-registry"
  subnets = ["subnet-9c4ab1c5"]
  internal = true
  security_groups = ["${module.base.prod_twitch_security_group}"]

  listener {
    instance_port = 5000
    instance_protocol = "http"
    lb_port = 80
    lb_protocol = "http"
  }

  listener {
    instance_port = 5000
    instance_protocol = "http"
    lb_port = 443
    lb_protocol = "https"
    ssl_certificate_id = "arn:aws:iam::673385534282:server-certificate/wildcard.internal.justin.tv"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "tcp:5000"
    interval = 30
  }

  instances = ["${aws_instance.docker-registry.id}"]
  cross_zone_load_balancing = true
}
