module "base" {
    source = "../base"
}

provider "aws" {
    region = "us-west-2"
}

resource "aws_instance" "github-secure-backup" {
	ami = "${module.base.ami}"
	instance_type = "t2.medium"
	subnet_id = "${module.base.dev_avail_zone_0}"
	security_groups = ["${module.base.dev_twitch_security_group}"]
  iam_instance_profile = "github_secure_backup"
	  user_data = <<END_OF_STRING
#cloud-config
hostname: "github-secure-backup"
fqdn: "github-secure-backup.dev.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=github-secure-backup" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=dev" > /etc/facter/facts.d/twitch_environment.txt
 - echo "app_env=dev" > /etc/facter/facts.d/app_env.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test
END_OF_STRING
	tags {
		Name = "github-secure-backup"
	}
	ebs_block_device {
		device_name= "/dev/xvdf"
		delete_on_termination= false
		volume_size= 64
		volume_type= "gp2"
	}
}

resource "aws_route53_record" "github-secure-backup" {
   count = "1"
   zone_id = "${module.base.r53}"
   name = "github-secure-backup.dev.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.github-secure-backup.*.private_ip}"]
}
