Setup
=====
To set up, run the setup_ghe.sh script:

```
setup_ghe.sh
```

You will be prompted for the domain name that should be created in route53 for your ghe instance. The script will then create the GHE instance at that domain name. It will run terraform for you to do this, and will store all the terraform files needed for this in a directory named after your domain name.

If you wish to keep this GHE instance running for a while and wish to keep track of the instance, and don't want others to use this domain, then commit this directory to the tree.

Passwords
=========
When it completes, you should be able to hit your domain name, and log in as username/password: skadi/G1thubtest.

You can access the management console at http://$YOUR_IP:8080/setup/unlock, and the password is G1thubtest.

SSH
===
You can ssh in if you provided your ssh pub key while setup_ghe.sh was running. You can ssh in using:

```
ssh -p 122 admin@your-domain
```

If you didn't upload keys, then you will need to upload them from the management console. To do that, go to http://$YOUR_IP:8080/setup/unlock, and add your pubkey under "Add new SSH key".

LDAP won't work since this is based off of GHE's AMI. For more information, see https://help.github.com/enterprise/2.0/admin-guide/administrative-shell-ssh-access/.

Termination
===========
To kill your instance, run "terraform destroy  -var-file $DOMAIN_NAME/generated.tfvars -state $DOMAIN_NAME/terraform.tfstate"
