module "base" {
    source = "../base"
}

provider "aws" {
    region = "us-west-2"
}

variable "ids" {
	default {
		# Route53 zones:
		privateR53 = "ZRG00SM48517Z"
	}
}

variable "domain_name" {
  description = "Domain name that follows: git.*.dev.us-west2.justin.tv"
}


#####################################
# Github Enterprise Dev Environment #
#####################################

resource "aws_instance" "ghe_test" {
  ami = "ami-830116b3"
	instance_type = "r3.large"
	subnet_id = "${module.base.dev_avail_zone_0}"
	security_groups = ["${module.base.dev_twitch_security_group}"]
  ebs_block_device = {
    device_name = "/dev/sda1"
    snapshot_id = "snap-5a299e04"
  }
  ebs_block_device = {
    device_name = "/dev/xvdf"
    snapshot_id = "snap-eb20c9ae"
  }
  tags {
    Name = "git.${var.domain_name}"
  }
}

resource "aws_route53_record" "dev-ghe" {
   zone_id = "${var.ids.privateR53}"
   name = "git.${var.domain_name}.dev"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.ghe_test.private_ip}"]
}


output "ghe_ip" {
 value = "${aws_instance.ghe_test.private_ip}"
}

output "ghe_hostname" {
 value = "${aws_route53_record.dev-ghe.fqdn}"
}
