while true; do
  read -p "Enter domain name for your ghe instance (ex: git-YOURVALUE.dev.us-west2.justin.tv): " GHE_NAME
  read -p "Confirm that $GHE_NAME is what you want to create: (y/n)" yn
  case "$yn" in
    y|Y ) break;;
    n|N ) echo "Please re-enter";;
    * ) echo "Invalid selection, please choose y or n";;
  esac
done
while true; do
  read -p "Enter the api_key user password to use when connecting to the instance. You can find it in our LastPass account: " GHE_PASS
  read -p "Confirm that $GHE_PASS is what you want to create: (y/n)" yn
  case "$yn" in
    y|Y ) break;;
    n|N ) echo "Please re-enter";;
    * ) echo "Invalid selection, please choose y or n";;
  esac
done

mkdir $GHE_NAME
TFSTATE=$GHE_NAME/terraform.tfstate
# NOTE: we're generating a file because doing:
# TFPLAN=$TFPLAN" -var 'domain_name=$GHE_NAME'"
# and running that within this shell script doesn't work as expected
# but running that via the cli directly is fine...
echo "Using the following .tfstate file: $TFSTATE"
echo 'domain_name = "'$GHE_NAME'"' > $GHE_NAME/generated.tfvars
TFPLAN="terraform plan -var-file $GHE_NAME/generated.tfvars -state $TFSTATE"
TFAPPLY="terraform apply -var-file $GHE_NAME/generated.tfvars -state $TFSTATE"
TFIP="terraform output -state $TFSTATE ghe_ip"
TFNAME="terraform output -state $TFSTATE ghe_hostname"
terraform get
if [ $? != 0 ]; then
  echo "Failed terraform get call, exiting"
  exit 1
fi
$TFPLAN
if [ $? != 0 ]; then
  echo "Failed terraform plan call, exiting"
  exit 1
fi
$TFAPPLY
if [ $? != 0 ]; then
  echo "Failed terraform apply call, exiting"
  exit 1
fi
YOUR_IP=$($TFIP)
if [ $? != 0 ]; then
  echo "Failed terraform output ghe_ip call, exiting"
  exit 1
fi
YOUR_NAME=$($TFNAME)
if [ $? != 0 ]; then
  echo "Failed terraform output ghe_hostname call, exiting"
  exit 1
fi
echo "Waiting for management console to be ready..."
tries=0
until [ $tries -ge 20 ]; do
  curl -I http://api_key:$GHE_PASS@$YOUR_IP:8080/setup/api/settings | grep 200
  if [ $? = 0 ]; then
    break
  fi
  sleep 5
done
if [ $tries -eq 20 ]; then
  echo "Could not auto configure ghe. Log in to http://api_key:$GHE_PASS@$YOUR_IP:8080/setup/ using password G1thubtest and set its hostname to the domain name you selected"
  exit 1
fi
curl -L "http://api_key:$GHE_PASS@$YOUR_IP:8080/setup/api/settings" > settings.json
sed -i -e 's/git.test230.dev.us-west2.justin.tv/'$YOUR_NAME'/g' settings.json
curl -L -X PUT "http://api_key:$GHE_PASS@$YOUR_IP:8080/setup/api/settings" --data-urlencode "settings=`cat settings.json`"
curl -L -X POST "http://api_key:$GHE_PASS@$YOUR_IP:8080/setup/api/configure"
echo "Your instance is now ready at: $YOUR_IP and $YOUR_NAME"
while true; do
  read -p "Upload your ssh key to the instance? (y/n)?" choice
  case "$choice" in
    y|Y ) read -p "Enter the absolute path to your ssh pub key: " pkey; curl --insecure -L -X POST "http://api_key:$GHE_PASS@$YOUR_IP:8080/setup/api/settings/authorized-keys" -F authorized_key=@$pkey;break;;
    n|N ) echo "Not uploading keys"; break;;
    * ) echo "Invalid selection, please choose y or n";;
  esac
done
echo "Done, your tfstate file is located in $GHE_NAME"
