module "base" {
    source = "../base"
}

provider "aws" {
    region = "us-west-2"
}

#################################
# Github Enterprise Backup Test #
#################################

resource "aws_instance" "git_002_prod_us_west2_justin_tv" {
	ami = "ami-b7654687"
	instance_type = "m3.xlarge"
	subnet_id = "${module.base.dev_avail_zone_0}"
	security_groups = ["${module.base.dev_twitch_security_group}"]
	user_data = "{\"twitch_role\": \"github-enterprise\", \"twitch_environment\":\"production\", \"cluster\": \"github-enterprise\", \"fqdn\": \"git-002.prod.us-west2.justin.tv\"}"
	tags {
		Name = "git-002.prod.us-west2.justin.tv"
	}
	block_device {
		device_name= "/dev/xvdf"
		delete_on_termination= false
		volume_size= 64
		encrypted= true
		volume_type= "gp2"
	}
}

resource "aws_eip" "git-002" {
	instance = "${aws_instance.git_002_prod_us_west2_justin_tv.id}"
	vpc = true
}
