provider "aws" {
	region = "us-west-2"
}

variable "domain" {
	default = "grafana.prod.us-west2.justin.tv"
}

resource "aws_route53_record" "grafana" {
	zone_id = "ZRG00SM48517Z"
	name = "${var.domain}"
	type = "A"
	ttl = "300"
	records = ["${aws_instance.grafana26.*.private_ip}"]
}

resource "aws_instance" "grafana" {
	ami = "ami-ede5f18c"
	instance_type = "m3.xlarge"
	subnet_id = "subnet-faa4239f"
	security_groups = ["sg-27d18d42"]
	iam_instance_profile = "grafana_profile"
	tags {
		Name = "${var.domain}"
		Owner = "james@twitch.tv"
	}
	user_data = <<EOT
#cloud-config
runcmd:
 - [ sed, "-i.bak", "s/{{domain}}/${var.domain}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_host}}/${aws_db_instance.grafana_rds.endpoint}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_name}}/${aws_db_instance.grafana_rds.name}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_user}}/${aws_db_instance.grafana_rds.username}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_pass}}/${aws_db_instance.grafana_rds.password}/g", "/etc/grafana/grafana.ini" ]
 - [ service, grafana-server, restart ]
EOT
}

resource "aws_instance" "grafana26" {
    ami = "ami-90b2adf1"
    instance_type = "m3.xlarge"
    subnet_id = "subnet-faa4239f"
    security_groups = ["sg-27d18d42"]
    iam_instance_profile = "grafana_profile"
    tags {
        Name = "${var.domain}"
        Owner = "james@twitch.tv"
    }
    user_data = <<EOT
#cloud-config
runcmd:
 - [ sed, "-i.bak", "s/{{domain}}/${var.domain}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_host}}/${aws_db_instance.grafana_rds.endpoint}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_name}}/${aws_db_instance.grafana_rds.name}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_user}}/${aws_db_instance.grafana_rds.username}/g", "/etc/grafana/grafana.ini" ]
 - [ sed, "-i.bak", "s/{{db_pass}}/${aws_db_instance.grafana_rds.password}/g", "/etc/grafana/grafana.ini" ]
 - [ service, grafana-server, restart ]
EOT
}

resource "aws_db_instance" "grafana_rds" {
    identifier = "grafana"
    allocated_storage = 10
    engine = "postgres"
    engine_version = "9.4.4"
    instance_class = "db.t2.small"
    name = "grafana"
    username = "grafana"
    password = "notsosecret"
	db_subnet_group_name = "grafana"
	vpc_security_group_ids = ["sg-27d18d42"]
}

resource "aws_iam_instance_profile" "grafana_profile" {
    name = "grafana_profile"
    roles = ["grafana-cloudwatch"]
}
