module "base" {
	source = "../base"
}

provider "aws" {
	region = "us-west-2"
}

resource "aws_instance" "huboard" {
	ami = "ami-51f9d961"
	instance_type = "r3.large"
	security_groups = ["${module.base.dev_twitch_security_group}"]
	subnet_id = "subnet-d4a423b1"
	key_name = "Dev/kthornhill-imac"
	tags {
		Owner = "kthornhill"
	}
}

resource "aws_route53_record" "huboard" {
	zone_id = "${module.base.r53}"
	name = "huboard.dev.us-west2.justin.tv"
	type = "A"
	ttl = "300"
	records = ["${aws_instance.huboard.private_ip}"]
}